//
// Created by 崔华根 on 2024/6/17.
//
#include <filesystem>
#include <string>
#include <iostream>
#include <cstdio>
#include <fstream>
#include <array>
#include <chrono>
#include <sstream>

std::string exec(const char* cmd) {
    std::array<char, 128> buffer;
    std::string result;
    std::unique_ptr<FILE, decltype(&pclose)> pipe(popen(cmd, "r"), pclose);
    if (!pipe) {
        throw std::runtime_error("popen() failed!");
    }
    while (fgets(buffer.data(), buffer.size(), pipe.get()) != nullptr) {
        result += buffer.data();
    }
    return result;
}

void writeFile(const std::string &filename, const std::string &content) {
    // 创建并打开文件，使用 trunc 模式来清空文件
    std::ofstream file(filename, std::ofstream::out | std::ofstream::trunc);

    // 检查文件是否成功打开
    if (!file) {
        std::cerr << "Failed to open " << filename << std::endl;
        return;
    }

    // 将内容写入文件
    file << content;

    // 关闭文件
    file.close();
}

long  getCurrentTime(){
    auto now = std::chrono::system_clock::now();
    // 转换为自纪元以来的时间长度
    auto duration = now.time_since_epoch();
    // 将时间长度转换为毫秒
    auto milliseconds = std::chrono::duration_cast<std::chrono::milliseconds>(duration);
//    std::stringstream ss;
//    ss << milliseconds.count();
//    std::string timestampStr = ss.str();
    return milliseconds.count();
}

bool endsWith(const std::string& str, const std::string& suffix) {
    if (str.length() >= suffix.length()) {
        // compare函数用于比较两个字符串。
        // 此处，它从str的(str.length() - suffix.length())位置开始比较，直到str的末尾，看它是否与suffix相同。
        return (0 == str.compare(str.length() - suffix.length(), suffix.length(), suffix));
    } else {
        return false;
    }
}

std::string ReplaceAll(std::string str,
                       const std::string& from,
                       const std::string& to) {
    size_t startPos = 0;
    while((startPos = str.find(from, startPos)) != std::string::npos) {
        str.replace(startPos, from.length(), to);
        startPos += to.length(); // Handles case where 'to' is a substring of 'from'
    }
    return str;
}

void copyFile(std::string sourceFile, std::string destinationFile) {
    std::ifstream src(sourceFile, std::ios::binary);
    std::ofstream dst(destinationFile, std::ios::binary);

    dst << src.rdbuf();
}

std::string transferCmd(std::string inputFilePath,std::string outputDir,std::string originFileName, int fps, int gop,std::string coder,bool isNoB) {
   auto beginTime = getCurrentTime();
    std::string outputFilePath = outputDir+"out_"+originFileName;
    if (fps>=0) {
        outputFilePath.append("_").append("fps").append(std::to_string(fps));
    }
    if (gop>=0) {
        outputFilePath.append("_").append("gop").append(std::to_string(gop));
    }
    if (!coder.empty()) {
        outputFilePath.append("_").append(coder);
    }
    if (isNoB){
        outputFilePath.append("_").append("nob");
    }
    outputFilePath.append(".mp4");
    std::cout<<"outputFilePath:"<<outputFilePath<<std::endl;

//    std::string ffmpeg_cmd = "ffmpeg -i "+inputFilePath+" -vf \"fps=30\" -g 30  -c:v libx264 -c:a copy -y "+outputFilePath;
    std::string ffmpeg_cmd;
    ffmpeg_cmd.append("ffmpeg -i ");
    ffmpeg_cmd.append(inputFilePath);
    ffmpeg_cmd.append(" ");
    if (fps>=0) {
        ffmpeg_cmd.append("-vf ");
        ffmpeg_cmd.append("\"fps=");
        ffmpeg_cmd.append(std::to_string(fps));
        ffmpeg_cmd.append("\" ");
    }
    if (gop>=0){
        ffmpeg_cmd.append("-g ");
        ffmpeg_cmd.append(std::to_string(30));
        ffmpeg_cmd.append(" ");
    }
    if (isNoB)
        ffmpeg_cmd.append("-bf 0 ");
    if (coder.empty()) {
        if (fps>=0 || gop>=0){

        }else {
            ffmpeg_cmd.append("-c:v ");
            ffmpeg_cmd.append("copy");
        }
    } else {
        ffmpeg_cmd.append("-c:v ");
        ffmpeg_cmd.append("lib");
        ffmpeg_cmd.append(coder);
    }
    ffmpeg_cmd.append(" ");
    ffmpeg_cmd.append("-c:a copy -y ");
    ffmpeg_cmd.append(outputFilePath);
    std::cout<<"ffmpeg_cmd:"<<ffmpeg_cmd<<std::endl;
    int result = std::system(ffmpeg_cmd.data());
    if (result != 0) {
        // 处理错误
    }
    auto endTime = getCurrentTime();
    auto interval = endTime-beginTime;
    std::string msg = "inputFilePath: "+inputFilePath+" fps:"+std::to_string(fps)+" gop:"+std::to_string(gop)+" coder:"+coder;
    msg.append("\n");
    msg.append("time cost:");
    msg.append(std::to_string(interval));
    msg.append("ms");
    msg.append("\n");
    msg.append("\n");
    return msg;
}

int main() {
    std::string inputDir ="/Users/gengen/Downloads/material-jingxiaoshang/";
    std::string outputDir="/Users/gengen/Downloads/material-jingxiaoshang-out/";
    // 创建文件夹
    std::filesystem::path dirPath(outputDir);
    if (!std::filesystem::create_directory(outputDir)) {
        std::cout << "Failed to create directory."<<outputDir<<std::endl;
//        return 1;
    }
    int index =0;
    for (const auto &entry : std::filesystem::directory_iterator(inputDir)) {
//        std::cout << entry.path().filename().string() << std::endl;
//    if (index>0) {
//        break;
//    }
       std::string  inputPath = entry.path();

       if (!endsWith(inputPath,".mp4") && !endsWith(inputPath,".mov")&& !endsWith(inputPath,".MOV")&& !endsWith(inputPath,".MP4")){
           continue;
       }
        std::cout<<" input:"<<inputPath<<std::endl;

       std::string fileName = entry.path().filename();
        std::cout<<" fileName:"<<inputPath<<std::endl;
        std::string  newFileName=fileName;
        newFileName=ReplaceAll(newFileName,".mp4","");
        newFileName=ReplaceAll(newFileName,".MP4","");
        newFileName=ReplaceAll(newFileName,".mov","");
        newFileName=ReplaceAll(newFileName,".MOV","");
        std::cout<<" newFileName:"<<newFileName<<std::endl;
        std::string newOutputDir=outputDir;
        newOutputDir.append(newFileName).append("/");
        if (!std::filesystem::create_directory(newOutputDir)) {
            std::cout << "Failed to create directory."<<newOutputDir<<std::endl;
//        return 1;
        }
       std::string fileTextName =newFileName+".txt";

       std::string fileInfoPath = newOutputDir+fileTextName;
        std::cout<<" fileInfoPath:"<<fileInfoPath<<std::endl;

        std::string cmd = "ffprobe -v 0 -of csv=p=0 -select_streams v:0 -show_entries stream=r_frame_rate "+inputPath;
        std::string result = exec(cmd.c_str());

      std::string cmd2="ffprobe -v 0 -select_streams v:0 -show_entries frame=best_effort_timestamp_time,pict_type -of csv=p=0 "+inputPath+" | grep -e 'I'";
        std::string result2 = exec(cmd2.c_str());
//        std::cout << "I帧间隔= "<<result2<<std::endl;

        std::string  finalResult = +"frame rate= "+result+"\n"+"I帧间隔= \n"+result2;
        writeFile(fileInfoPath,finalResult);
        //3. 复制源文件到输出文件夹
        std::string outputOriginFile =newOutputDir+fileName;
        std::cout<<" outputOriginFile:"<<inputPath<<std::endl;
        copyFile(inputPath,outputOriginFile);
        std::string timeCostInfoPath =newOutputDir+newFileName+"_cost"+".txt";
        std::string record;
//        record.append( transferCmd(inputPath,newOutputDir,newFileName,-1,-1,""));
//        record.append(transferCmd(inputPath,newOutputDir,newFileName,-1,-1,"x265"));
//        record.append( transferCmd(inputPath,newOutputDir,newFileName,-1,30,""));
        record.append( transferCmd(inputPath,newOutputDir,newFileName,-1,60,"x265",true));
        record.append( transferCmd(inputPath,newOutputDir,newFileName,-1,60,"",true));
        record.append(transferCmd(inputPath,newOutputDir,newFileName,-1,60,"x265",false));
        record.append( transferCmd(inputPath,newOutputDir,newFileName,-1,60,"",false));
        std::cout<<"record result:"<<record<<std::endl;

        //        transferCmd(inputPath,newOutputDir,newFileName,-1,30,"x264");
//        transferCmd(inputPath,newOutputDir,newFileName,30,30,"");
//        transferCmd(inputPath,newOutputDir,newFileName,30,30,"x264");
//        transferCmd(inputPath,newOutputDir,newFileName,30,30,"x265");

//        transferCmd(inputPath,newOutputDir,newFileName,-1,-1,"x264");

//        transferCmd(inputPath,newOutputDir,newFileName,30,-1,"");
//        transferCmd(inputPath,newOutputDir,newFileName,30,-1,"x264");
//        transferCmd(inputPath,newOutputDir,newFileName,30,-1,"x265");
        writeFile(timeCostInfoPath,record);
        index++;
    }
    std::cout<<"end of work"<<std::endl;
    return 0;
}