package com.afanticar.afantiopenapi.controller;

import com.afanticar.afantiopenapi.mapper.OpenApiClientPrincipalRelationMapper;
import com.afanticar.afantiopenapi.model.BaseResponse;
import com.afanticar.afantiopenapi.model.dto.ImMessageDataDto;
import com.afanticar.afantiopenapi.model.dto.ImMessageRecordDto;
import com.afanticar.afantiopenapi.model.dto.ImMessageRequestDto;
import com.afanticar.afantiopenapi.model.dto.OpenIdDTO;
import com.afanticar.afantiopenapi.model.entity.LiveCrmCustomerChat;
import com.afanticar.afantiopenapi.service.BaseService;
import com.afanticar.afantiopenapi.service.LiveCrmCustomerChatService;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.pagehelper.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/clue/im/message")
public class ClueImMessageController extends BaseController {

    // 假设BaseService已经存在并被Spring管理
    @Autowired
    private BaseService baseService;
    @Autowired
    private LiveCrmCustomerChatService liveCrmCustomerChatService;
    @Autowired
    OpenApiClientPrincipalRelationMapper openApiClientPrincipalRelationMapper;

    /**
     * 查询互动列表
     */
    @PostMapping("/list")
    public BaseResponse<ImMessageDataDto> list(@RequestBody ImMessageRequestDto request) {
        // 添加频率控制，使用日期类型、限制次数和限制周期参数
        BaseResponse check = baseService.baseLimit("im_message_list", 100, 60);
        if (check != null) {
            return check;
        }
        // 根据 request.getStoreCode()和request.getPhoneNo()找到AuthorOpenId和FansOpenId
        List<OpenIdDTO> openIdDTOList = openApiClientPrincipalRelationMapper.getOpenIdByStoreCodeAndPhone(request.getStoreCode(), request.getPhoneNo());
        if(CollectionUtils.isEmpty(openIdDTOList)){
            return  success(new ImMessageDataDto());
        }

        // 使用分页查询表数据返回
        Page<LiveCrmCustomerChat> page = new Page<>(request.getCurrent(), request.getSize());
        LambdaQueryWrapper<LiveCrmCustomerChat> queryWrapper = new LambdaQueryWrapper<>();
        openIdDTOList.forEach(openIdDTO -> {
            queryWrapper.or().eq(LiveCrmCustomerChat::getAuthorOpenId, openIdDTO.getAuthorOpenId())
                    .eq(LiveCrmCustomerChat::getFansOpenId, openIdDTO.getUserOpenId());
        });

        if ("desc".equals(request.getTimeSort())) {
            queryWrapper.orderByDesc(LiveCrmCustomerChat::getPublishTime);
        }
        Page<LiveCrmCustomerChat> iPageData = liveCrmCustomerChatService.page(page, queryWrapper);
        ImMessageDataDto imMessageDataDto = new ImMessageDataDto();
        imMessageDataDto.setTotal(iPageData.getTotal());
        imMessageDataDto.setCurrent(iPageData.getCurrent());
        imMessageDataDto.setSize(iPageData.getSize());
        imMessageDataDto.setPages(iPageData.getPages());
        List< ImMessageRecordDto> imMessageRecordDtos = new ArrayList<>();
        iPageData.getRecords().forEach(liveCrmCustomerChat -> {
            ImMessageRecordDto imMessageRecordDto = new ImMessageRecordDto();
            imMessageRecordDto.setAuthorNickname(liveCrmCustomerChat.getAuthorNickname());
            imMessageRecordDto.setAuthorAvatar(liveCrmCustomerChat.getAuthorAvatar());
            imMessageRecordDto.setCustomerNickname(liveCrmCustomerChat.getFansNickname());
            imMessageRecordDto.setCustomerAvatar(liveCrmCustomerChat.getFansAvatar());
            imMessageRecordDto.setIsAuthorSend(liveCrmCustomerChat.getIsAuthorSend());
            imMessageRecordDto.setMessageTime(liveCrmCustomerChat.getPublishTime());
            imMessageRecordDto.setContent(liveCrmCustomerChat.getContent());
            imMessageRecordDtos.add(imMessageRecordDto);
        });
        imMessageDataDto.setRecords(imMessageRecordDtos);

        return success(imMessageDataDto);
    }

}