package com.afanticar.afantiopenapi.model.dto;

import com.alibaba.fastjson.annotation.JSONType;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import java.util.Date;
import java.util.List;

/**
 * @author chin
 * @contact chenyan@afanticar.com
 * @since 2024/9/13/013
 */
@Data
@JsonNaming(value = com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy.class)
@JSONType(naming = com.alibaba.fastjson.PropertyNamingStrategy.SnakeCase)
public class FawActivityDTO {

    @Min(value = 1, message = "当前页最小1")
    private Integer current;

    @Max(value = 1000, message = "分页大小最大1000")
    private Integer size;

    private String publishDateStart;

    private Date start;

    private String publishDateEnd;

    private Date end;

    private List<String> activityIds;

}
