package com.afanticar.afantiopenapi.utils;

import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;

import java.util.Base64;

/**
 * @author chin
 * @contact chenyan@afanticar.com
 * @since 2023/4/26/026
 */
public class JWTUtils {

    public static String getClientId(String token) {
        DecodedJWT jwt = JWT.decode(token);
        Base64.Decoder decoder = Base64.getUrlDecoder();
        String payload = new String(decoder.decode(jwt.getPayload()));
        return JSONObject.parseObject(payload).getString("client_id");
    }

}
