package com.afanticar.afantiopenapi.model.entity;

//import com.afanticar.marketing.onedata.domain.dto.MatrixMessageDto;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * @author liuyudong
 * @desc
 * @Date 2023/08/08
 **/
@TableName(value ="live_crm_customer_chat_all")
@Data
public class LiveCrmCustomerChat {
    /**
     * 私信历史记录主键id
     */
    @TableId(type = IdType.INPUT)
    private String id;

    /**
     * fans_open_id
     */
    private String fansOpenId;

    /**
     * fans_nickname
     */
    private String fansNickname;

    /**
     * author_open_id
     */
    private String authorOpenId;

    /**
     * author_id
     */
    private String authorId;

    /**
     * content
     */
    private String content;

    /**
     * 私信的发送者，0粉丝，1主播
     */
    private Integer isAuthorSend;

    /**
     * 是否已读，0未读，1已读
     */
    private Integer isRead;

    /**
     * 创建时间
     */
    private Date ctime;

    /**
     * 联系方式
     */
    private String contact;

    /**
     * 车型名称字符串拼接，以逗号分隔
     */
    private String seriesId;

    /**
     * fans_id
     */
    private String fansId;

    /**
     * fans_avatar
     */
    private String fansAvatar;

    /**
     * 抖音快手的code
     */
    private String fansCode;

    /**
     * author_nickname
     */
    private String authorNickname;

    /**
     * author_avatar
     */
    private String authorAvatar;

    /**
     * 实际私信时间
     */
    private Date publishTime;

    /**
     * 平台私信id
     */
    private String msgId;

    /**
     * 风火轮使用人名称
     */
    private String userName;

    /**
     * 会话id
     */
    private String shortId;

    /**
     * 进入私信回话 0-否 1-是
     */
    private String isEnterDirect;

    /**
     * 外部信息（包含：表情url、视频itemid、卡片信息）
     */
    private String externalInfo;

    /**
     * 消息类型（1：文本；2：图片；3：表情；4：视频；5：消息卡片；6：其他；） )  engine = distributed( default ， marketing_rawdata ， live_crm_customer_chat_local ， hivehash(id)
     */
    private Integer messageType;

    private Integer isDouyinSend;

    private Integer reachFunctionType;

    /**
     * 主体id
     */
    private String principalId;

    /**
     * 主体名称
     */
    private String principalName;

    /**
     * 一级区域id
     */
    private String regionId;

    /**
     * 一级区域名称
     */
    private String regionName;

    /**
     * 二级区域id
     */
    private String villageId;

    /**
     * 二级区域名称
     */
    private String villageName;

    /**
     * 成员ID
     */
    private String memberId;
    /**
     * 成员编号
     */
    private String memberCode;

    /**
     * 成员名称
     */
    private String memberName;

    /**
     * 策略id
     */
    private String sceneId;
    /**
     * 策略名称
     */
    private String sceneName;

    /**
     * 触发抖音发送不成功错误描述记录
     */
    private String errorMsg;


    private Integer functionType=0;

//    public void setMatrix(MatrixMessageDto dto){
//        if(dto != null){
//            this.principalId = dto.getPrincipalId();
//            this.principalName = dto.getPrincipalName();
//            this.regionId = dto.getRegionId();
//            this.regionName = dto.getRegionName();
//            this.villageId = dto.getVillageId();
//            this.villageName = dto.getVillageName();
//            this.memberId = dto.getMemberId();
//            this.memberCode = dto.getMemberCode();
//            this.memberName = dto.getMemberName();
//        }
//    }
}
