package com.afanticar.afantiopenapi.model.dto;

import com.alibaba.fastjson.annotation.JSONType;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author chin
 * @contact chenyan@afanticar.com
 * @since 2023/4/27/027
 */
@Data
@JsonNaming(value = com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy.class)
@JSONType(naming = com.alibaba.fastjson.PropertyNamingStrategy.SnakeCase)
@ApiModel("token请求DTO")
public class TokenDTO {

    @ApiModelProperty(value = "client_id", example = "200")
    @NotNull
    private String clientId;

    private String grantType;

    @ApiModelProperty(value = "秘钥", example = "200")
    @NotNull
    private String clientSecret;

}
