package com.afanticar.afantiopenapi.model.entity;

import com.alibaba.fastjson.annotation.JSONType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.Data;

import java.util.Date;

/**
 * 红旗视频激励记录表_月度
 * @author chin
 * @contact chenyan@afanticar.com
 * @since 2023/4/26/026
 */
@Data
@TableName("hongqi_aweme_incentive_monthly")
@JsonNaming(value = com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy.class)
@JSONType(naming = com.alibaba.fastjson.PropertyNamingStrategy.SnakeCase)
public class HongqiAwemeIncentiveMonthly {

    /** 活动ID */
    private Integer activityId;
    /** 统计日期 */
    private Date statisticsDate;
    private String groupName;
    /** 平台 */
    private String platform;
    /** 大区 */
    private String region;
    /** 门店编码 */
    private String storeCode;
    /** 经销商名称 */
    private String dealerName;
    /** 主播ID */
    private String authorId;
    /** 视频ID */
    private String awemeId;
    /** 标题 */
    private String title;
    /** 链接 */
    private String link;
    /** 视频发布时间 */
    private Date publishTime;
    /** 点赞数 */
    private Integer likeCount;
    /** 评论数 */
    private Integer commentCount;
    /** 分享数 */
    private Integer shareCount;
    /** 播放数 */
    private Integer playVolume;
    /** 互动数 */
    private Integer interaction;
    /** 是否有效作品 1是, 0否 */
    private Integer isValid;
    /** 是否活动作品 1是, 0否 */
    private Integer isActivity;
    /** 是否爆款作品 1是, 0否 */
    private Integer isPopular;
    /** 是否违规作品 1是, 0否 */
    private Integer isViolation;
    /** 违规标签 */
    private String violationTag;
    /** 门店内排行 */
    private String storeRanking;
    /** 爆款作品奖金 */
    private Long popularWorksBonus;
    /** 是否删除数据 1是, 0否 */
    private Integer isDeleted;
    /** 创建时间 */
    private Date ctime;
    /** 更新时间 */
    private Date mtime;

}
