package com.afanticar.afantiopenapi.model.entity;

import com.alibaba.fastjson.annotation.JSONType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.Data;
import org.springframework.data.annotation.Id;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 红旗项目门店月度预值表
 */
@Data
@TableName("hongqi_project_store_expected_value_info")
@JsonNaming(value = com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy.class)
@JSONType(naming = com.alibaba.fastjson.PropertyNamingStrategy.SnakeCase)
public class HongqiProjectStoreExpectedValueInfo {

    @Id
    private Integer id;
    private String groupName;
    private String storeCode;
    private String storeName;
    private Integer expectedMonth;
    private BigDecimal dailyAwemeValue;
    private BigDecimal dailyLiveValue;
    private BigDecimal hotAwemeValue;
    private BigDecimal hotLiveValue;
    private BigDecimal growthIncentiveValue;
    private BigDecimal negativeIncentiveValue;
    private BigDecimal teamIncentiveValue;
    private BigDecimal specialProjectValue;
    private BigDecimal innovateAwemeRechargeValue;
    private BigDecimal replyMinute3Rate;
    private BigDecimal msgConversionRate;
    private BigDecimal cpl;
    private BigDecimal innovateAwemeValue;
    private BigDecimal hotLiveLineValue;
    private Date ctime;
    private Date mtime;

}
