package com.afanticar.afantiopenapi.model.vo;

import com.alibaba.fastjson.annotation.JSONType;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 红旗直播激励记录表_月度
 * @author chin
 * @contact chenyan@afanticar.com
 * @since 2023/4/26/026
 */
@Data
@JsonNaming(value = com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy.class)
@JSONType(naming = com.alibaba.fastjson.PropertyNamingStrategy.SnakeCase)
public class HongqiLiveIncentiveVO {
    /** 活动ID */
    @ApiModelProperty(value = "活动ID", example = "200")
    private Integer activityId;
    /** 统计日期 */
    @ApiModelProperty(value = "统计日期", example = "2023-03-03")
    private Date statisticsDate;
    /** 分组 */
    @ApiModelProperty(value = "分组", example = "分组2")
    private String groupName;
    /** 平台 */
    @ApiModelProperty(value = "平台", example = "抖音")
    private String platform;
    /** 大区 */
    @ApiModelProperty(value = "大区", example = "大区200")
    private String region;
    /** 门店编码 */
    @ApiModelProperty(value = "门店编码", example = "ABC123")
    private String storeCode;
    /** 经销商名称 */
    @ApiModelProperty(value = "经销商名称", example = "经销商200")
    private String dealerName;
    /** 主播ID */
    @ApiModelProperty(value = "主播ID", example = "200")
    private String authorId;
    /** 直播ID */
    @ApiModelProperty(value = "直播ID", example = "11200")
    private String roomId;
    /** 标题 */
    @ApiModelProperty(value = "标题", example = "标题200")
    private String title;
    /** 链接 */
    @ApiModelProperty(value = "链接", example = "链接")
    private String link;
    /** 视频发布时间 */
    @ApiModelProperty(value = "视频发布时间", example = "2023-03-03 10:00:02")
    private Date publishTime;
    /** 点赞数 */
    @ApiModelProperty(value = "点赞数", example = "200")
    private Integer likeCount;
    /** 评论数 */
    @ApiModelProperty(value = "评论数", example = "200")
    private Integer commentCount;
    /** 送礼数 */
    @ApiModelProperty(value = "送礼数", example = "200")
    private Integer giftCount;
    /** 观看量 */
    @ApiModelProperty(value = "观看量", example = "200")
    private Integer watchUserCount;
    /** 直播时长（分钟） */
    @ApiModelProperty(value = "直播时长（分钟）", example = "210")
    private Long liveDuration;
    /** 互动数 */
    @ApiModelProperty(value = "互动数", example = "200")
    private Integer interaction;
    /** 是否有效作品 1是, 0否 */
    @ApiModelProperty(value = "是否有效作品", example = "1")
    private Integer isValid;
    /** 是否活动作品 1是, 0否 */
    @ApiModelProperty(value = "是否活动作品", example = "1")
    private Integer isActivity;
    /** 是否爆款作品 1是, 0否 */
    @ApiModelProperty(value = "是否爆款作品", example = "1")
    private Integer isPopular;
    /** 是否违规作品 1是, 0否 */
    @ApiModelProperty(value = "是否违规作品", example = "0")
    private Integer isViolation;
    /** 违规标签 */
    @ApiModelProperty(value = "违规标签", example = "[0]")
    private String violationTag;
    /** 门店内排行 */
    @ApiModelProperty(value = "门店内排行", example = "2")
    private String storeRanking;
    /** 爆款作品奖金 */
    @ApiModelProperty(value = "爆款作品奖金", example = "200")
    private Long popularWorksBonus;
}
