package com.afanticar.afantiopenapi.config;

import cn.hutool.core.util.StrUtil;
import com.afanticar.afantiopenapi.controller.BaseController;
import com.afanticar.afantiopenapi.utils.JWTUtils;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Set;

/**
 * @author chin
 * @contact chenyan@afanticar.com
 * @since 2023/4/26/026
 */
@Component
@Slf4j
public class TokenInterceptor implements HandlerInterceptor {

    @Value("#{'${ignored.uri}'.split(',')}")
    private Set<String> ignoredUris;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String requestUri = request.getRequestURI();
        if (ignoredUris.contains(requestUri)) {
            return true;
        }
        String token = request.getHeader("authorization");
        if (StrUtil.isNotBlank(token)) {
            request.setAttribute("clientId", JWTUtils.getClientId(token.substring(8)));
        } else {
            response.setCharacterEncoding("UTF-8");
            response.setStatus(HttpServletResponse.SC_UNAUTHORIZED);
            response.setContentType("application/json");
            response.getWriter().append(JSONObject.toJSONString(BaseController.error("401", "认证失败")));
            return false;
        }
        return true;
    }

}
