package com.afanticar.afantiopenapi.service;

import com.afanticar.afantiopenapi.mapper.*;
import com.afanticar.afantiopenapi.mapper.struct.HongqiAwemeIncentiveStructMapper;
import com.afanticar.afantiopenapi.mapper.struct.HongqiLiveIncentiveStructMapper;
import com.afanticar.afantiopenapi.model.dto.FawActivityDTO;
import com.afanticar.afantiopenapi.model.entity.HongqiAwemeIncentiveMonthly;
import com.afanticar.afantiopenapi.model.entity.HongqiAwemeIncentiveQuarter;
import com.afanticar.afantiopenapi.model.entity.HongqiLiveIncentiveMonthly;
import com.afanticar.afantiopenapi.model.entity.HongqiLiveIncentiveQuarter;
import com.afanticar.afantiopenapi.model.vo.*;
import com.afanticar.afantiopenapi.utils.BaseUtils;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.pagehelper.PageHelper;
import org.mapstruct.factory.Mappers;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @author chin
 * @contact chenyan@afanticar.com
 * @since 2023/4/26/026
 */
@Service
public class FawOpenService {

    @Resource
    HongqiAwemeIncentiveMonthlyMapper hongqiAwemeIncentiveMonthlyMapper;

    @Resource
    HongqiAwemeIncentiveQuarterMapper hongqiAwemeIncentiveQuarterMapper;

    @Resource
    HongqiLiveIncentiveMonthlyMapper hongqiLiveIncentiveMonthlyMapper;

    @Resource
    HongqiLiveIncentiveQuarterMapper hongqiLiveIncentiveQuarterMapper;

    @Resource
    DwdKuaishouAuthorInfoMapper dwdKuaishouAuthorInfoMapper;

    static String monthly = "monthly";

    static String quarter = "quarter";

    public BasePageVO<HongqiAwemeIncentiveVO> awemes(Date publishDateStart, Date publishDateEnd, String type, Integer pageNum, Integer pageSize) {
        try {
            TimeUnit.MILLISECONDS.sleep(500L);
        } catch (InterruptedException ignored) {
        }
        PageHelper.orderBy(" publish_time DESC ");
        if (monthly.equals(type)) {
            IPage<HongqiAwemeIncentiveMonthly> page = new Page<>(pageNum, pageSize);
            QueryWrapper<HongqiAwemeIncentiveMonthly> queryWrapper = new QueryWrapper<>();
            queryWrapper.between("publish_time", publishDateStart, publishDateEnd);
            IPage<HongqiAwemeIncentiveMonthly> awemePage = hongqiAwemeIncentiveMonthlyMapper.selectPage(page, queryWrapper);
            HongqiAwemeIncentiveStructMapper mapper = Mappers.getMapper(HongqiAwemeIncentiveStructMapper.class);
            List<HongqiAwemeIncentiveVO> vos = mapper.listLiveMonthlyToVO(awemePage.getRecords());
            return BasePageVO.restPage(pageNum, (int) awemePage.getSize(), (int) awemePage.getTotal(), (int) awemePage.getPages(), vos);
        } else if (quarter.equals(type)) {
            IPage<HongqiAwemeIncentiveQuarter> page = new Page<>(pageNum, pageSize);
            QueryWrapper<HongqiAwemeIncentiveQuarter> queryWrapper = new QueryWrapper<>();
            queryWrapper.between("publish_time", publishDateStart, publishDateEnd);
            IPage<HongqiAwemeIncentiveQuarter> awemePage = hongqiAwemeIncentiveQuarterMapper.selectPage(page, queryWrapper);
            HongqiAwemeIncentiveStructMapper mapper = Mappers.getMapper(HongqiAwemeIncentiveStructMapper.class);
            List<HongqiAwemeIncentiveVO> vos = mapper.listLiveQuarterToVO(awemePage.getRecords());
            return BasePageVO.restPage(pageNum, (int) awemePage.getSize(), (int) awemePage.getTotal(), (int) awemePage.getPages(), vos);
        } else {
            return new BasePageVO<>();
        }
    }

    public BasePageVO<HongqiLiveIncentiveVO> lives(Date publishDateStart, Date publishDateEnd, String type, Integer pageNum, Integer pageSize) {
        try {
            TimeUnit.MILLISECONDS.sleep(500L);
        } catch (InterruptedException ignored) {
        }
        PageHelper.orderBy(" publish_time DESC ");
        if (monthly.equals(type)) {
            IPage<HongqiLiveIncentiveMonthly> page = new Page<>(pageNum, pageSize);
            QueryWrapper<HongqiLiveIncentiveMonthly> queryWrapper = new QueryWrapper<>();
            queryWrapper.between("publish_time", publishDateStart, publishDateEnd);
            IPage<HongqiLiveIncentiveMonthly> awemePage = hongqiLiveIncentiveMonthlyMapper.selectPage(page, queryWrapper);
            HongqiLiveIncentiveStructMapper mapper = Mappers.getMapper(HongqiLiveIncentiveStructMapper.class);
            List<HongqiLiveIncentiveVO> vos = mapper.listLiveMonthlyToVO(awemePage.getRecords());
            return BasePageVO.restPage(pageNum, (int) awemePage.getSize(), (int) awemePage.getTotal(), (int) awemePage.getPages(), vos);
        } else if (quarter.equals(type)) {
            IPage<HongqiLiveIncentiveQuarter> page = new Page<>(pageNum, pageSize);
            QueryWrapper<HongqiLiveIncentiveQuarter> queryWrapper = new QueryWrapper<>();
            queryWrapper.between("publish_time", publishDateStart, publishDateEnd);
            IPage<HongqiLiveIncentiveQuarter> awemePage = hongqiLiveIncentiveQuarterMapper.selectPage(page, queryWrapper);
            HongqiLiveIncentiveStructMapper mapper = Mappers.getMapper(HongqiLiveIncentiveStructMapper.class);
            List<HongqiLiveIncentiveVO> vos = mapper.listLiveQuarterToVO(awemePage.getRecords());
            return BasePageVO.restPage(pageNum, (int) awemePage.getSize(), (int) awemePage.getTotal(), (int) awemePage.getPages(), vos);
        } else {
            return new BasePageVO<>();
        }
    }

    public BasePageVO<HongqiActivityAwemeVO> douyinActivityAwemes(FawActivityDTO dto) {
        PageHelper.orderBy(" publish_time DESC ");
        IPage<HongqiActivityAwemeVO> page = new Page<>(dto.getCurrent(), dto.getSize());
        IPage<HongqiActivityAwemeVO> awemePage = dwdKuaishouAuthorInfoMapper.douyinActivityAwemes(page, dto);
        BaseUtils.parseSeries(awemePage.getRecords());
        return BasePageVO.restPage(dto.getCurrent(), (int) awemePage.getSize(), (int) awemePage.getTotal(), (int) awemePage.getPages(), awemePage.getRecords());
    }

    public BasePageVO<HongqiActivityLiveVO> douyinActivityLives(FawActivityDTO dto) {
        PageHelper.orderBy(" publish_time DESC ");
        IPage<HongqiActivityLiveVO> page = new Page<>(dto.getCurrent(), dto.getSize());
        IPage<HongqiActivityLiveVO> livePage = dwdKuaishouAuthorInfoMapper.douyinActivityLives(page, dto);
        BaseUtils.parseSeries(livePage.getRecords());
        return BasePageVO.restPage(dto.getCurrent(), (int) livePage.getSize(), (int) livePage.getTotal(), (int) livePage.getPages(), livePage.getRecords());
    }


    public BasePageVO<HongqiActivityAwemeVO> kuaishouActivityAwemes(FawActivityDTO dto) {
        PageHelper.orderBy(" publish_time DESC ");
        IPage<HongqiActivityAwemeVO> page = new Page<>(dto.getCurrent(), dto.getSize());
        IPage<HongqiActivityAwemeVO> awemePage = dwdKuaishouAuthorInfoMapper.kuaishouActivityAwemes(page, dto);
        BaseUtils.parseSeries(awemePage.getRecords());
        return BasePageVO.restPage(dto.getCurrent(), (int) awemePage.getSize(), (int) awemePage.getTotal(), (int) awemePage.getPages(), awemePage.getRecords());
    }

    public BasePageVO<HongqiActivityLiveVO> kuaishouActivityLives(FawActivityDTO dto) {
        PageHelper.orderBy(" publish_time DESC ");
        IPage<HongqiActivityLiveVO> page = new Page<>(dto.getCurrent(), dto.getSize());
        IPage<HongqiActivityLiveVO> livePage = dwdKuaishouAuthorInfoMapper.kuaishouActivityLives(page, dto);
        BaseUtils.parseSeries(livePage.getRecords());
        return BasePageVO.restPage(dto.getCurrent(), (int) livePage.getSize(), (int) livePage.getTotal(), (int) livePage.getPages(), livePage.getRecords());
    }

}
