package com.afanticar.afantiopenapi.model.vo;

import com.alibaba.fastjson.annotation.JSONType;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

@Data
@JsonNaming(value = com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy.class)
@JSONType(naming = com.alibaba.fastjson.PropertyNamingStrategy.SnakeCase)
public class BydXiaoHongShuMemberDayVO {
    /**
     * BydXiaoHongShuMemberDayVO(storeName=null, storeCode=null, storeId=null, storeType=null, areaName=南区,
     * villageName=, principalName=SWM斯威汽车, provinceName=广东省, cityName=广州市, statsDate=null, fansCntTotal=null,
     * fansCntDi=null, noteCntDi=null, noteLikeCntDi=null, noteCommentCntDi=null, noteFavoriteCntDi=null, noteShareCntDi=null)
     *
     * b.matrix_member_name as member_name,b.matrix_member_code as member_code,\n" +
     *             "       b.area_name,b.village_name,b.principal_name,b.province_name,b.city_name,\n" +
     *             "       a.statistics_day,a.fans_count_total,a.fans_count_total_di,a.note_count_di,\n" +
     *             "       a.note_digg_count_di,a.note_collect_count_di,a.note_share_count_di  \n" +
     */
    @ApiModelProperty(value = "品牌名称", example = "比亚迪-海洋")
    private String principalName;
    @ApiModelProperty(value = "门店名称", example = "南京宁星")
    private String memberName;
    @ApiModelProperty(value = "门店编码", example = "ABC123")
    private String memberCode;
    @ApiModelProperty(value = "大区名称", example = "大区名称1")
    private String areaName;
    @ApiModelProperty(value = "小区名称", example = "200")
    private String villageName;
    @ApiModelProperty(value = "省份名称", example = "广东")
    private String provinceName;
    @ApiModelProperty(value = "城市名称", example = "深圳")
    private String cityName;

    @ApiModelProperty(value = "统计日期", example = "2023-03-03")
    private LocalDate statsDate;
    @ApiModelProperty(value = "粉丝数", example = "200")
    private Integer fansCntTotal;
    @ApiModelProperty(value = "粉丝新增数", example = "200")
    private Integer fansCntDi;
    @ApiModelProperty(value = "笔记新增数", example = "200")
    private Integer noteCntDi;
    @ApiModelProperty(value = "笔记点赞新增数", example = "200")
    private Integer noteLikeCntDi;
    @ApiModelProperty(value = "笔记评论新增数", example = "200")
    private Integer noteCommentCntDi;
    @ApiModelProperty(value = "笔记收藏新增数", example = "200")
    private Integer noteFavoriteCntDi;
    @ApiModelProperty(value = "笔记分享新增数", example = "200")
    private Integer noteShareCntDi;
}
