package com.afanticar.afantiopenapi.config;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.afanticar.afantiopenapi.constant.Constant;
import com.afanticar.afantiopenapi.controller.BaseController;
import com.afanticar.afantiopenapi.feign.AfantiCasFeign;
import com.afanticar.afantiopenapi.model.vo.TokenCheckVO;
import com.afanticar.afantiopenapi.utils.JWTUtils;
import com.alibaba.fastjson.JSONObject;
import feign.FeignException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.lang.Nullable;

import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author chin
 * @contact chenyan@afanticar.com
 * @since 2023/4/26/026
 */
@Slf4j
@Component
public class CommonInterceptor extends HandlerInterceptorAdapter {

    @Autowired
    private AfantiCasFeign casFeign;

    @Autowired
    private RedissonClient redissonClient;

    @Autowired
    private IgnoredUri ignoredUri;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String requestUri = request.getRequestURI();
        log.info("请求uri" + requestUri);
        if (ignoredUri.getUris().contains(requestUri)) {
            return true;
        }
        String token = request.getHeader("authorization");
        if (StrUtil.isNotBlank(token)) {
            // 红旗旧接口不进行验证
            if(Constant.EXCLUDE_PATH.contains(requestUri)){
                return true;
            }
            try{
                String clientId = JWTUtils.getClientId(token);
                request.setAttribute("clientId", clientId);
                TokenCheckVO tokenCheckVO = this.getCasToken(clientId,token);
                if(tokenCheckVO == null || DateUtil.currentSeconds() > Long.valueOf(tokenCheckVO.getExp()).longValue()){
                    this.writeResponse(response,"token已过期");
                    return false;
                }
            }catch (FeignException e){
                if(e.status()==HttpServletResponse.SC_UNAUTHORIZED){
                    this.writeResponse(response,"Unauthorized");
                    return false;
                }
            }catch (Exception e){
                this.writeResponse(response,"认证失败,无效的token");
                return false;
            }
        } else {
            this.writeResponse(response,"认证失败,无效的token");
            return false;
        }
        return true;
    }

    //    @Override
//    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler,
//                                @Nullable Exception ex) throws Exception {
//        if (response.getStatus() == 200) {
//            try {
//                Thread.sleep(5000);
//            } catch (InterruptedException e) {
//                throw new RuntimeException(e);
//            }
//        }
//    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler,
                           @Nullable ModelAndView modelAndView) throws Exception {
        // 在当前请求的 Controller 方法调用之后，且在 DispatcherServlet 进行视图返回渲染之前被调用。
        // 注意，只有当所属拦截器的 preHandle 方法返回值为 true 时，该拦截器的 postHandle 方法才会被调用.
        try {
            Thread.sleep(5000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }


    private void writeResponse(HttpServletResponse response, String msg) throws Exception {
        response.setCharacterEncoding("UTF-8");
        response.setStatus(HttpServletResponse.SC_UNAUTHORIZED);
        response.setContentType("application/json");
        response.getWriter().append(JSONObject.toJSONString(BaseController.error("401", msg)));
    }

    private TokenCheckVO getCasToken(String clientId,String token) {
//        RBucket<TokenCheckVO> rBucket = redissonClient.getBucket(Constant.TOKEN_REDIS_KEY+clientId);
//        if(!rBucket.isExists()){
//            RLock lock = redissonClient.getLock(Constant.TOKEN_REDIS_LOCK+clientId);
//            lock.lock(5,TimeUnit.SECONDS);
//            try{
        TokenCheckVO checkVO = casFeign.checkToken(token);
//                rBucket.set(checkVO,24, TimeUnit.HOURS);
        return checkVO;
//            }catch (Exception e){
//                throw e;
//            }finally {
//                if(lock.isLocked()){
//                    lock.unlock();
//                }
//            }
//        }else{
//            return rBucket.get();
//        }
    }

}
