package com.afanticar.afantiopenapi.config;

import com.afanticar.afantiopenapi.controller.BydOpenController;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import javax.annotation.Resource;

/**
 * @author chin
 * @contact chenyan@afanticar.com
 * @since 2023/4/28/028
 */
@Configuration
public class WebMvcConfig implements WebMvcConfigurer {

//    @Resource
//    TokenInterceptor tokenInterceptor;

    @Resource
    BydOpenController bydOpenController;

    @Bean
    public CommonInterceptor getLoginInterceptor(){
        return new CommonInterceptor();
    }


    @Override
    public void addInterceptors(InterceptorRegistry register) {
        register.addInterceptor(getLoginInterceptor());
        register.addInterceptor(bydOpenController);
    }

}