package com.afanticar.afantiopenapi.model.entity;

import com.alibaba.fastjson.annotation.JSONType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.Data;

import java.util.Date;

@Data
@TableName("dim_matrix_member_info")
@JsonNaming(value = com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy.class)
@JSONType(naming = com.alibaba.fastjson.PropertyNamingStrategy.SnakeCase)
public class MemberInfo {
    /**
     * 成员id
     */
    private String matrixMemberId;

    /**
     * 成员名称
     */
    private String matrixMemberName;

    /**
     * 成员类型 1:经销商 2:官号 3:直营店 4:二网 5:城市站 6:KOL/KOC
     */
    private Byte matrixMemberType;

    /**
     * 成员编码
     */
    private String matrixMemberCode;

    /**
     * 联络人
     */
    private String username;

    /**
     * 联络人手机号
     */
    private String mobile;

    /**
     * 邀请码
     */
    private String invitationCode;

    /**
     * 省份ID
     */
    private String provinceId;

    /**
     * 省份名称
     */
    private String provinceName;

    /**
     * 城市ID
     */
    private String cityId;

    /**
     * 城市名称
     */
    private String cityName;

    /**
     * 主体ID
     */
    private String principalId;

    /**
     * 主体名称
     */
    private String principalName;

    /**
     * 大区ID
     */
    private String areaId;

    /**
     * 大区名称
     */
    private String areaName;

    /**
     * 小区ID
     */
    private String villageId;

    /**
     * 小区名称
     */
    private String villageName;

    /**
     * 0:默认值,1:正常,2:退网
     */
    private Byte status;

    /**
     * 操作时间
     */
    private Date atime;

    /**
     * 创建时间
     */
    private Date ctime;

    /**
     * 更新时间
     */
    private Date mtime;

    /**
     * 创建人
     */
    private String creator;

    /**
     * 操作人
     */
    private String actor;

    /**
     * 是否已删除,(1:是;0:否)
     */
    private Byte isDeleted;

    /**
     * 是否有效，0：无效，1：有效
     */
    private Integer isValid;

    /**
     * 记录有效开始时间
     */
    private Date startTime;

    /**
     * 记录有效结束时间
     */
    private Date endTime;
}
