package com.afanticar.afantiopenapi.model.entity;

import com.alibaba.fastjson.annotation.JSONType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

@Data
@TableName("dws_xiaohongshu_note_action_day")
@JsonNaming(value = com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy.class)
@JSONType(naming = com.alibaba.fastjson.PropertyNamingStrategy.SnakeCase)
public class XiaoHongShuNoteDay extends BaseADB{
    /**
     * 小红书号
     */
    private String authorId;

    /**
     * 笔记id
     */
    private String noteId;

    /**
     * 阅读量
     */
    private Integer readCount;

    /**
     * 直接涨粉数
     */
    private Integer fansTotalAdd;

    /**
     * 点赞量
     */
    private Integer diggCount;

    /**
     * 收藏数
     */
    private Integer collectCount;

    /**
     * 评论数
     */
    private Integer commentCount;

    /**
     * 分享数
     */
    private Integer shareCount;

    /**
     * 阅读量增量
     */
    private Integer readCountDi;

    /**
     * 直接涨粉数增量
     */
    private Integer fansTotalAddDi;

    /**
     * 点赞量增量
     */
    private Integer diggCountDi;

    /**
     * 收藏数增量
     */
    private Integer collectCountDi;

    /**
     * 评论数增量
     */
    private Integer commentCountDi;

    /**
     * 分享数增量
     */
    private Integer shareCountDi;

    /**
     * 该行是否取自自前一天, 0:否；1:是
     */
    private Boolean isFromP0;

    /**
     * 统计日期，格式为YYYY-MM-DD 00:00:00
     */
    private LocalDate statisticsDay;

    /**
     * 入库时间
     */
    private LocalDateTime ctime;

    /**
     * 修改时间
     */
    private LocalDateTime mtime;

    /**
     * 成员ID数组
     */
    private String matrixMemberIds;

    /**
     * 是否为推测数据
     */
    private Boolean isSimulateData;

    /**
     * 笔记状态： 1-可见，0-不可见
     */
    private Integer noteStatus;

    /**
     * 预估的模拟阅读量：（点赞+评论+收藏+转发）*20
     */
    private Integer simulateReadCount;

    /**
     * 预估的模拟阅读增量：（点赞增量+评论增量+收藏增量+转发增量）*20
     */
    private Integer simulateReadCountDi;

    public List<String> getMemberIds() {
        return getList(this.matrixMemberIds);
    }
}
