package com.afanticar.afantiopenapi.model.vo;

import com.alibaba.fastjson.annotation.JSONType;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

@Data
@JsonNaming(value = com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy.class)
@JSONType(naming = com.alibaba.fastjson.PropertyNamingStrategy.SnakeCase)
public class BydXiaoHongShuAuthorDayVO {

    @ApiModelProperty(value = "主播ID", example = "123456")
    private String authorId;
    @ApiModelProperty(value = "主播昵称", example = "张三")
    private String nickname;
    @ApiModelProperty(value = "主播code", example = "a123456")
    private String code;
    @ApiModelProperty(value = "主播头像", example = "http://xxxxx")
    private String avatarUrl;
    @ApiModelProperty(value = "是否蓝V", example = "true|false")
    private boolean isBlueV;
    @ApiModelProperty(value = "账号收录时间", example = "2024-11-01 14:21:12")
    private LocalDateTime includeTime;

    @ApiModelProperty(value = "成员信息", example = "[{...},{...}]")
    private List<MemberInfo> memberInfos;

    @ApiModelProperty(value = "统计日期", example = "2023-03-03")
    private LocalDate statsDate;

    @ApiModelProperty(value = "粉丝数", example = "200")
    private Integer fansCntTotal;
    @ApiModelProperty(value = "粉丝新增数", example = "200")
    private Integer fansCntDi;
    @ApiModelProperty(value = "笔记新增数", example = "200")
    private Integer noteCntDi;
    @ApiModelProperty(value = "笔记点赞新增数", example = "200")
    private Integer noteLikeCntDi;
    @ApiModelProperty(value = "笔记评论新增数", example = "200")
    private Integer noteCommentCntDi;
    @ApiModelProperty(value = "笔记收藏新增数", example = "200")
    private Integer noteFavoriteCntDi;
    @ApiModelProperty(value = "笔记分享新增数", example = "200")
    private Integer noteShareCntDi;
    @ApiModelProperty(value = "数据更新时间", example = "....")
    private LocalDateTime dataUpdateTime;

    @Data
    public static class MemberInfo {
        @ApiModelProperty(value = "品牌名称", example = "比亚迪-海洋")
        private String principalName;
        @ApiModelProperty(value = "门店ID", example = "A11111")
        private String memberId;
        @ApiModelProperty(value = "门店名称", example = "南京宁星")
        private String memberName;
        @ApiModelProperty(value = "门店编码", example = "ABC123")
        private String memberCode;
        @ApiModelProperty(value = "大区名称", example = "大区名称1")
        private String areaName;
        @ApiModelProperty(value = "小区名称", example = "200")
        private String villageName;
        @ApiModelProperty(value = "省份名称", example = "广东")
        private String provinceName;
        @ApiModelProperty(value = "城市名称", example = "深圳")
        private String cityName;
    }
}
