package com.afanticar.afantiopenapi.model.vo;

import com.alibaba.fastjson.annotation.JSONType;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

@Data
@JsonNaming(value = com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy.class)
@JSONType(naming = com.alibaba.fastjson.PropertyNamingStrategy.SnakeCase)
public class BydXiaoHongShuNoteDayVO {
    @ApiModelProperty(value = "笔记ID", example = "123456")
    private String noteId;
    @ApiModelProperty(value = "统计日期", example = "2023-03-03")
    private LocalDate statsDate;
    @ApiModelProperty(value = "笔记标题", example = "...")
    private String noteTitle;
    @ApiModelProperty(value = "主播ID", example = "123456")
    private String authorId;
    @ApiModelProperty(value = "发布时间", example = "2024-11-01 00:10:23")
    private LocalDateTime publishTime;

    @ApiModelProperty(value = "笔记类型", example = "笔记类型（normal：图文，video：视频）")
    private String noteType;
    @ApiModelProperty(value = "分享链接", example = "...")
    private String shareUrl;
    @ApiModelProperty(value = "封面链接", example = "...")
    private String coverUrl;
    @ApiModelProperty(value = "话题列表", example = "...")
    private List<String> topicNames;

    @ApiModelProperty(value = "笔记点赞数", example = "200")
    private Integer likeCnt;
    @ApiModelProperty(value = "笔记评论数", example = "200")
    private Integer commentCnt;
    @ApiModelProperty(value = "笔记收藏数", example = "200")
    private Integer collectCnt;
    @ApiModelProperty(value = "笔记分享数", example = "200")
    private Integer shareCnt;

    @ApiModelProperty(value = "笔记正文", example = "...")
    private String description;

    @ApiModelProperty(value = "数据更新时间", example = "....")
    private LocalDateTime dataUpdateTime;

}
