package com.afanticar.afantiopenapi.service;

import com.afanticar.afantiopenapi.config.Constant;
import com.afanticar.afantiopenapi.feign.AfantiCasFeign;
import com.afanticar.afantiopenapi.mapper.ActivityInfoMapper;
import com.afanticar.afantiopenapi.mapper.struct.ActivityInfoStructMapper;
import com.afanticar.afantiopenapi.model.BaseResponse;
import com.afanticar.afantiopenapi.model.dto.TokenDTO;
import com.afanticar.afantiopenapi.model.entity.ActivityInfo;
import com.afanticar.afantiopenapi.model.vo.ActivityInfoVO;
import com.afanticar.afantiopenapi.model.vo.BasePageVO;
import com.afanticar.afantiopenapi.model.vo.TokenVO;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.pagehelper.PageHelper;
import lombok.extern.slf4j.Slf4j;
import org.mapstruct.factory.Mappers;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author chin
 * @contact chenyan@afanticar.com
 * @since 2023/4/27/027
 */
@Service
@Slf4j
public class CommonDataService {

    @Resource
    ActivityInfoMapper activityInfoMapper;

    @Resource
    AfantiCasFeign afantiCasFeign;

    public BasePageVO<ActivityInfoVO> actionData(String principalId, Integer pageNum, Integer pageSize) {
        PageHelper.orderBy(" creation_time DESC ");
        IPage<ActivityInfo> page = new Page<>(pageNum, pageSize);
        QueryWrapper<ActivityInfo> queryWrapper = new QueryWrapper<>();
        //queryWrapper.eq("principal_id", principalId);
        IPage<ActivityInfo> activityPage = activityInfoMapper.selectPage(page, queryWrapper);
        ActivityInfoStructMapper mapper = Mappers.getMapper(ActivityInfoStructMapper.class);
        List<ActivityInfoVO> vos = mapper.listActivityInfoToVO(activityPage.getRecords());
        return BasePageVO.restPage(pageNum, (int) activityPage.getSize(), (int) activityPage.getTotal(), (int) activityPage.getPages(), vos);
    }

    public TokenVO token(TokenDTO dto) {
        dto.setGrantType("client_credentials");
        BaseResponse<TokenVO> response = afantiCasFeign.predict(JSONObject.parseObject(JSONObject.toJSONString(dto)).getInnerMap());
        if (Constant.SUCCESS_CODE.equals(response.getCode())) {
            return response.getData();
        }
        log.error("faw请求token失败：{}", JSONObject.toJSONString(response));
        return null;
    }

}
