package com.afanticar.afantiopenapi.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author chin
 * @contact chenyan@afanticar.com
 * @since 2023/4/26/026
 */
@Data
@ApiModel("数据返回DTO")
public class BaseResponse<T> {

    @ApiModelProperty(value = "状态码", example = "200")
    private String code;

    @ApiModelProperty(value = "状态信息", example = "success")
    private String message;

    @ApiModelProperty("数据")
    private T data;

    @ApiModelProperty(value = "是否成功", example = "true")
    private Boolean success;


}
