package com.afanticar.afantiopenapi.utils;

import com.afanticar.afantiopenapi.constant.Constant;
import com.afanticar.afantiopenapi.model.vo.ActivityVO;
import com.afanticar.afantiopenapi.model.vo.HongqiActivityAwemeVO;
import com.afanticar.afantiopenapi.model.vo.HongqiActivityBaseVO;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Base64;
import java.util.List;

public class BaseUtils {

    public static <T extends HongqiActivityBaseVO> void parseSeries(List<T> list) {
        for (HongqiActivityBaseVO awemeVO: list) {
            if (StringUtils.isEmpty(awemeVO.getActivityInfo())) {
                continue;
            }
            List<ActivityVO> activityVOList = new ArrayList<>();
            List<String> objects = JSONObject.parseArray(awemeVO.getActivityInfo(), String.class);
            for (String object : objects) {
                ActivityVO activityVO = JSONObject.parseObject(object, ActivityVO.class);
                activityVOList.add(activityVO);
                if (StringUtils.isEmpty(activityVO.getMatchKeywords())) {
                    continue;
                }
                StringBuffer seriesCode = new StringBuffer();
                String[] names = activityVO.getMatchKeywords().split(",");
                for (String name : names) {
                    String code = Constant.seriesMap.get(name);
                    if (StringUtils.isEmpty(code)) {
                        continue;
                    }
                    seriesCode.append(code).append(",");
                }
                activityVO.setSeriesCode(seriesCode.substring(0, seriesCode.length() - 1));
            }
            awemeVO.setActivityList(activityVOList);
        }
    }
}
