package com.afanticar.afantiopenapi.model.entity.adb;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

@Data
@TableName("dwd_douyin_aweme_info")
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class DwdDouyinAwemeInfo {

    /**
     * 视频id
     */
    private String awemeId;
    /**
     * 主播id
     */
    private String authorId;
    /**
     * 视频标题
     */
    private String awemeTitle;
    /**
     * 视频状态
     */
    private Integer awemeStatus;
    /**
     * 视频地址
     */
    private String awemeUrl;
    /**
     * 视频标签
     */
    private String awemeTopic;
    /**
     * 视频总播放量
     */
    private Integer playVolume;
    /**
     * 总评论数
     */
    private Integer commentCount;
    /**
     * 总分享数
     */
    private Integer shareCount;
    /**
     * 总点赞数
     */
    private Integer diggCount;
    /**
     * 视频时长（毫秒）
     */
    private Integer duration;
    /**
     * 视频发布时间
     */
    private Date publishTime;
    /**
     * 系统更新时间
     */
    private Date mtime;
    /**
     * 数据同步更新的时间点
     */
    private Date dataUpdateTime;
}
