package com.afanticar.afantiopenapi.service;

import com.afanticar.afantiopenapi.mapper.HongqiAwemeIncentiveMonthlyMapper;
import com.afanticar.afantiopenapi.mapper.HongqiAwemeIncentiveQuarterMapper;
import com.afanticar.afantiopenapi.mapper.HongqiLiveIncentiveMonthlyMapper;
import com.afanticar.afantiopenapi.mapper.HongqiLiveIncentiveQuarterMapper;
import com.afanticar.afantiopenapi.mapper.struct.HongqiAwemeIncentiveStructMapper;
import com.afanticar.afantiopenapi.mapper.struct.HongqiLiveIncentiveStructMapper;
import com.afanticar.afantiopenapi.model.entity.HongqiAwemeIncentiveMonthly;
import com.afanticar.afantiopenapi.model.entity.HongqiAwemeIncentiveQuarter;
import com.afanticar.afantiopenapi.model.entity.HongqiLiveIncentiveMonthly;
import com.afanticar.afantiopenapi.model.entity.HongqiLiveIncentiveQuarter;
import com.afanticar.afantiopenapi.model.vo.BasePageVO;
import com.afanticar.afantiopenapi.model.vo.HongqiAwemeIncentiveVO;
import com.afanticar.afantiopenapi.model.vo.HongqiLiveIncentiveVO;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.pagehelper.PageHelper;
import org.mapstruct.factory.Mappers;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * @author chin
 * @contact chenyan@afanticar.com
 * @since 2023/4/26/026
 */
@Service
public class FawOpenService {

    @Resource
    HongqiAwemeIncentiveMonthlyMapper hongqiAwemeIncentiveMonthlyMapper;

    @Resource
    HongqiAwemeIncentiveQuarterMapper hongqiAwemeIncentiveQuarterMapper;

    @Resource
    HongqiLiveIncentiveMonthlyMapper hongqiLiveIncentiveMonthlyMapper;

    @Resource
    HongqiLiveIncentiveQuarterMapper hongqiLiveIncentiveQuarterMapper;

    static String monthly = "monthly";

    static String quarter = "quarter";

    public BasePageVO<HongqiAwemeIncentiveVO> awemes(Date publishDateStart, Date publishDateEnd, String type, Integer pageNum, Integer pageSize) {
        PageHelper.orderBy(" publish_time DESC ");
        if (monthly.equals(type)) {
            IPage<HongqiAwemeIncentiveMonthly> page = new Page<>(pageNum, pageSize);
            QueryWrapper<HongqiAwemeIncentiveMonthly> queryWrapper = new QueryWrapper<>();
            queryWrapper.between("publish_time", publishDateStart, publishDateEnd);
            IPage<HongqiAwemeIncentiveMonthly> awemePage = hongqiAwemeIncentiveMonthlyMapper.selectPage(page, queryWrapper);
            HongqiAwemeIncentiveStructMapper mapper = Mappers.getMapper(HongqiAwemeIncentiveStructMapper.class);
            List<HongqiAwemeIncentiveVO> vos = mapper.listLiveMonthlyToVO(awemePage.getRecords());
            return BasePageVO.restPage(pageNum, pageSize, (int) awemePage.getTotal(), (int) awemePage.getPages(), vos);
        } else if (quarter.equals(type)) {
            IPage<HongqiAwemeIncentiveQuarter> page = new Page<>(pageNum, pageSize);
            QueryWrapper<HongqiAwemeIncentiveQuarter> queryWrapper = new QueryWrapper<>();
            queryWrapper.between("publish_time", publishDateStart, publishDateEnd);
            IPage<HongqiAwemeIncentiveQuarter> awemePage = hongqiAwemeIncentiveQuarterMapper.selectPage(page, queryWrapper);
            HongqiAwemeIncentiveStructMapper mapper = Mappers.getMapper(HongqiAwemeIncentiveStructMapper.class);
            List<HongqiAwemeIncentiveVO> vos = mapper.listLiveQuarterToVO(awemePage.getRecords());
            return BasePageVO.restPage(pageNum, pageSize, (int) awemePage.getTotal(), (int) awemePage.getPages(), vos);
        } else {
            return new BasePageVO<>();
        }
    }

    public BasePageVO<HongqiLiveIncentiveVO> lives(Date publishDateStart, Date publishDateEnd, String type, Integer pageNum, Integer pageSize) {
        PageHelper.orderBy(" publish_time DESC ");
        if (monthly.equals(type)) {
            IPage<HongqiLiveIncentiveMonthly> page = new Page<>(pageNum, pageSize);
            QueryWrapper<HongqiLiveIncentiveMonthly> queryWrapper = new QueryWrapper<>();
            queryWrapper.between("publish_time", publishDateStart, publishDateEnd);
            IPage<HongqiLiveIncentiveMonthly> awemePage = hongqiLiveIncentiveMonthlyMapper.selectPage(page, queryWrapper);
            HongqiLiveIncentiveStructMapper mapper = Mappers.getMapper(HongqiLiveIncentiveStructMapper.class);
            List<HongqiLiveIncentiveVO> vos = mapper.listLiveMonthlyToVO(awemePage.getRecords());
            return BasePageVO.restPage(pageNum, pageSize, (int) awemePage.getTotal(), (int) awemePage.getPages(), vos);
        } else if (quarter.equals(type)) {
            IPage<HongqiLiveIncentiveQuarter> page = new Page<>(pageNum, pageSize);
            QueryWrapper<HongqiLiveIncentiveQuarter> queryWrapper = new QueryWrapper<>();
            queryWrapper.between("publish_time", publishDateStart, publishDateEnd);
            IPage<HongqiLiveIncentiveQuarter> awemePage = hongqiLiveIncentiveQuarterMapper.selectPage(page, queryWrapper);
            HongqiLiveIncentiveStructMapper mapper = Mappers.getMapper(HongqiLiveIncentiveStructMapper.class);
            List<HongqiLiveIncentiveVO> vos = mapper.listLiveQuarterToVO(awemePage.getRecords());
            return BasePageVO.restPage(pageNum, pageSize, (int) awemePage.getTotal(), (int) awemePage.getPages(), vos);
        } else {
            return new BasePageVO<>();
        }
    }
}
