package com.afanticar.afantiopenapi.model.entity;

import com.alibaba.fastjson.annotation.JSONType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @author hejincai
 * @since 2025/4/24 9:54
 **/
@Data
@TableName("dws_afanti_adb_data_oss_record")
@JsonNaming(value = com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy.class)
@JSONType(naming = com.alibaba.fastjson.PropertyNamingStrategy.SnakeCase)
public class DwsAfantiAdbDataOssRecordEntity {

    @ApiModelProperty("主体id")
    private String principalId;

    @ApiModelProperty("统计的日期")
    private LocalDateTime statisticsDay;

    @ApiModelProperty("平台类型 public-公共数据 douyin-抖音 kuaishou-快手xiaohongshu-小红书 shipinhao-视频号")
    private String platform;

    @ApiModelProperty("数据报表类型 author_info-主播信息 aweme_info-视频信息 live_info-直播member_info-门店信息  note_info 笔记信息")
    private String dataType;

    @ApiModelProperty("文件地址")
    private String ossUrl;

    @ApiModelProperty("文件名称")
    private String fileName;

    @ApiModelProperty("创建时间")
    private LocalDateTime ctime;

    @ApiModelProperty("修改时间")
    private LocalDateTime mtime;
}
