package com.afanticar.afantiopenapi.model.dto;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * @author hejincai
 * @since 2025/4/23 16:41
 **/
@Data
@ApiModel(description = "数据报表请求入参")
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class DataReportRequestDTO {

    @ApiModelProperty("开始时间。格式为：yyyy-MM-dd。例如2024-01-01")
    @NotBlank(message = "开始时间不可为空")
    private String startTime;

    @ApiModelProperty("结束时间。格式为：yyyy-MM-dd。例如2024-01-01")
    @NotBlank(message = "结束时间不可为空")
    private String endTime;
    
    @ApiModelProperty("平台类型 public-公共数据 douyin-抖音 kuaishou-快手xiaohongshu-小红书 shipinhao-视频号")
    @NotEmpty(message = "平台类型不可为空，可选类型 public-公共数据 douyin-抖音 kuaishou-快手xiaohongshu-小红书 shipinhao-视频号 ")
    private List<String> platformList;

    @ApiModelProperty("数据报表类型 author_info-主播信息 aweme_info-视频信息 live_info-直播member_info-门店信息 note_info-小红书信息")
    @NotEmpty(message = "平台类型不可为空，可选类型 author_info-主播信息 aweme_info-视频信息 live_info-直播 member_info-门店信息 note_info-小红书信息")
    private List<String> dataTypeList;

    @ApiModelProperty("页码。默认为1")
    private Integer page = 1;

    @ApiModelProperty("页面大小。最大100，默认100")
    private Integer size = 100;

    @ApiModelProperty(value = "主体id", hidden = true)
    private String principalId;
}
