package com.afanticar.afantiopenapi.mapper;

import com.afanticar.afantiopenapi.model.entity.XiaoHongShuNoteDay;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.time.LocalDate;

@Mapper
@DS("afanti-bi-app")
public interface XiaoHongShuNoteDayMapper extends BaseMapper<XiaoHongShuNoteDay> {


    @Select("<script> \n" +
            "select * \n" +
            "from dws_xiaohongshu_note_action_day \n" +
            "where author_id in (\n" +
            "   select author_id from ads_xiaohongshu_author_info \n" +
            "   where contains(principal_ids, #{principalId}) and is_deleted=0 \n" +
            ") \n" +
            "<if test=\"pubStart != null and pubEnd != null\">" +
            "and note_id in (\n" +
            "   select note_id from ads_xiaohongshu_note_info \n" +
            "   where publish_time between #{pubStart} and #{pubEnd} \n" +
            ")\n" +
            "</if>" +
            "and statistics_day &gt;= #{statsStart} \n" +
            "and statistics_day &gt;= #{statsEnd} \n" +
            "order by statistics_day,note_id \n" +
            "</script>"
    )
    Page<XiaoHongShuNoteDay> queryNoteDayByPrincipalId(
            Page page,
            @Param("principalId") String principalId,
            @Param("statsStart") LocalDate statsStart,
            @Param("statsEnd") LocalDate statsEnd,
            @Param("pubStart") LocalDate pubStart,
            @Param("pubEnd") LocalDate pubEnd
    );
}
