package com.afanticar.afantiopenapi.model.entity;

import com.alibaba.fastjson.annotation.JSONType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.Data;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;

@Data
@TableName("dws_xiaohongshu_author_action_day")
@JsonNaming(value = com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy.class)
@JSONType(naming = com.alibaba.fastjson.PropertyNamingStrategy.SnakeCase)
public class XiaoHongShuAuthorDay extends BaseADB{
    /**
     * 统计日期，格式为YYYY-MM-DD 00:00:00
     */
    private LocalDate statisticsDay;

    /**
     * 主播ID
     */
    private String authorId;

    /**
     * 粉丝总数
     */
    private Integer fansCountTotal;

    /**
     * 本日新增粉丝数
     */
    private Integer fansCountTotalDi;

    /**
     * 获赞+收藏总数
     */
    private Integer favedCount;

    /**
     * 本日新增获赞+收藏数
     */
    private Integer favedCountDi;

    /**
     * 关注总数
     */
    private Integer followingCount;

    /**
     * 本日新增关注数
     */
    private Integer followingCountDi;

    /**
     * 本日笔记发布数
     */
    private Integer noteCountDi;

    /**
     * 本日笔记新增观看数
     */
    private Integer noteReadCountDi;

    /**
     * 本日笔记新增点赞数
     */
    private Integer noteDiggCountDi;

    /**
     * 本日笔记新增收藏数
     */
    private Integer noteCollectCountDi;

    /**
     * 本日笔记新增评论数
     */
    private Integer noteCommentCountDi;

    /**
     * 本日笔记新增分享数
     */
    private Integer noteShareCountDi;

    /**
     * 是否取自前一天的数据，0表示否，1表示是
     */
    private Boolean isFromP0;

    /**
     * 数据更新时间
     */
    private Date mtime;

    /**
     * 数据创建时间
     */
    private Date ctime;

    /**
     * 成员ID数组
     */
    private String matrixMemberIds;

    /**
     * 是否为推测数据
     */
    private Boolean isSimulateData;

    /**
     * 总点赞数
     */
    private Integer diggCountTotal;

    /**
     * 本日新增点赞数
     */
    private Integer diggCountDi;

    /**
     * 总收藏数
     */
    private Integer collectCountTotal;

    /**
     * 本日新增收藏数
     */
    private Integer collectCountDi;

    /**
     * 本日总作品数
     */
    private Integer noteCountTotal;

    /**
     * 本日直播总场次
     */
    private Integer liveTotalCount;

    /**
     * 本日直播总点赞数
     */
    private Integer liveTotalLikeCount;

    /**
     * 本日直播总点赞人数
     */
    private Integer liveTotalLikeUserCount;

    /**
     * 本日直播总评论数
     */
    private Integer liveTotalCommentCount;

    /**
     * 本日直播总评论人数
     */
    private Integer liveTotalCommentUserCount;

    /**
     * 本日直播总送礼数
     */
    private Integer liveTotalGiftCount;

    /**
     * 本日直播总送礼人数
     */
    private Integer liveTotalGiftUserCount;

    /**
     * 本日直播总互动数（评论数+点赞数+送礼数）
     */
    private Integer liveTotalPollingCount;

    /**
     * 本日直播总互动人数
     */
    private Integer liveTotalPollingUserCount;

    /**
     * 本日直播总时长
     */
    private Integer liveTotalTime;

    /**
     * 本日直播总新增粉丝数
     */
    private Integer liveTotalFansAdd;

    /**
     * 本日直播总薯钻
     */
    private Integer liveTotalDiamondCount;

    /**
     * 本日直播总观看人数
     */
    private Integer liveTotalWatchUserCount;

    /**
     * 本日直播总观看人次
     */
    private Integer liveTotalWatchUserTime;

    public List<String> getMemberIds() {
        return getList(this.matrixMemberIds);
    }
}
