package com.afanticar.afantiopenapi.model.entity.adb;

import com.alibaba.fastjson.annotation.JSONType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 抖音直播间信息
 * </p>
 *
 * @author Wsr
 * @since 2023-02-09
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("dwd_douyin_live_info")
@ApiModel(value = "DwdDouyinLiveInfo对象", description = "抖音直播间信息")
@JsonNaming(value = com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy.class)
@JSONType(naming = com.alibaba.fastjson.PropertyNamingStrategy.SnakeCase)
public class DwdDouyinLiveInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId("room_id")
    private String roomId;

    @ApiModelProperty("主播ID")
    @TableField("author_id")
    private String authorId;

    @ApiModelProperty("直播标题")
    @TableField("title")
    private String title;

    @ApiModelProperty("视频封面")
    @TableField("cover")
    private String cover;

    @ApiModelProperty("直播开始时间")
    @TableField("publish_time")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date publishTime;

    @ApiModelProperty("直播结束时间")
    @TableField("finish_time")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date finishTime;

    @ApiModelProperty("本场直播总观看人数(去重，需自己统计)")
    @TableField("statistics_total_watch_user_count")
    private Integer statisticsTotalWatchUserCount;

    @ApiModelProperty("本场直播总观看人次（没去重，对标直播间报告中的watch_cnt）")
    @TableField("statistics_total_watch_user_time")
    private Integer statisticsTotalWatchUserTime;

    @ApiModelProperty("本场直播总评论数")
    @TableField("statistics_total_comment_count")
    private Integer statisticsTotalCommentCount;

    @ApiModelProperty("本场最高在线人数（取直播报告事件中user_count或直播进入房间人员信息事件中user_count最高的值）")
    @TableField("statistics_max_online_user")
    private Integer statisticsMaxOnlineUser;

    @ApiModelProperty("本场直播总点赞数")
    @TableField("statistics_total_like_count")
    private Integer statisticsTotalLikeCount;

    @ApiModelProperty("本场直播时长")
    @TableField("statistics_live_time")
    private Integer statisticsLiveTime;

    @ApiModelProperty("本场直播新增粉丝数")
    @TableField("statistics_fans_add")
    private Integer statisticsFansAdd;

}
