package com.afanticar.afantiopenapi.controller;

import com.afanticar.afantiopenapi.config.ClientIdPrincipalConfig;
import com.afanticar.afantiopenapi.model.BaseResponse;
import com.afanticar.afantiopenapi.model.dto.TokenDTO;
import com.afanticar.afantiopenapi.model.vo.ActivityInfoVO;
import com.afanticar.afantiopenapi.model.vo.BasePageVO;
import com.afanticar.afantiopenapi.model.vo.TokenVO;
import com.afanticar.afantiopenapi.service.BaseService;
import com.afanticar.afantiopenapi.service.CommonDataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.Max;

/**
 * @author chin
 * @contact chenyan@afanticar.com
 * @since 2023/4/27/027
 */
@Api("公共数据接口")
@RestController
@RequestMapping("/public")
@Slf4j
@Validated
public class CommonDataController extends BaseController {

    @Autowired
    ClientIdPrincipalConfig clientIdPrincipalConfig;

    @Autowired
    CommonDataService commonDataService;

    @Autowired
    BaseService baseService;

    @Value("${common.limit.period:60}")
    Integer limitPeriod;

    @Value("${common.limit.threshold:8}")
    Integer limit;

    static String dateType = "common";

    @ApiOperation(value = "活动数据信息", notes = "活动数据", produces = "application/json")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "current_page", value = "页码", paramType = "path", dataType = "Integer"),
            @ApiImplicitParam(name = "page_size", value = "页数", paramType = "path", dataType = "Integer"),
    })
    @GetMapping("/activity")
    public BaseResponse<BasePageVO<ActivityInfoVO>> getActionData(HttpServletRequest request, @Max(value = 500,message = "单页数据page_size过大") @RequestParam(name = "page_size", defaultValue = "100", required = false) Integer pageSize,
                                                                  @RequestParam(name = "current_page", defaultValue = "1", required = false) Integer pageNum) {
        BaseResponse check = baseService.baseLimit(request, dateType, limit, limitPeriod);
        if (check != null) {
            return check;
        }
        String principalId = clientIdPrincipalConfig.getMaps().get(request.getHeader(header));
        return success(commonDataService.actionData(principalId, pageNum, pageSize));
    }

    @ApiOperation(value = "获取token", notes = "token数据", produces = "application/json")
    @PostMapping("/token")
    public BaseResponse<TokenVO> getToken(@RequestBody @Valid TokenDTO dto) {
        BaseResponse check = baseService.baseLimit(null, dateType, limit, limitPeriod);
        if (check != null) {
            return check;
        }
        TokenVO vo = commonDataService.token(dto);
        if (vo == null) {
           return error();
        }
        return success(vo);
    }

}
