package com.afanticar.afantiopenapi.mapper;

import com.afanticar.afantiopenapi.model.dto.FawActivityDTO;
import com.afanticar.afantiopenapi.model.entity.DwdDouyinAuthorInfo;
import com.afanticar.afantiopenapi.model.vo.HongqiActivityAwemeVO;
import com.afanticar.afantiopenapi.model.vo.HongqiActivityLiveVO;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

/**
 * <p>
 * 抖音主播信息 Mapper 接口
 * </p>
 *
 * @author Wsr
 * @since 2023-02-09
 */
@Mapper
@DS("afanti-bi-app")
public interface DwdDouyinAuthorInfoMapper extends BaseMapper<DwdDouyinAuthorInfo> {

    @Select("<script>select  " +
            "    t1.aweme_id,  " +
            "    t1.aweme_title ,  " +
            "    'douyin' as platform,  " +
            "    t3.dealer_area_names area_name,  " +
            "    t3.dealer_store_code dealer_code,  " +
            "    t3.dealer_name ,  " +
            "    t3.nickname ,  " +
            "    t1.publish_time ,  " +
            "    t1.play_volume ,  " +
            "    nvl(t1.digg_count,0) + nvl(t1.comment_count,0) + nvl(t1.share_count,0) as polling_count,  " +
            "    t1.digg_count ,  " +
            "    t1.comment_count ,  " +
            "    t1.share_count ,  " +
            "    t1.share_url ,  " +
            "    t1.data_update_time ,  " +
            "    t2.activity_id_list  " +
            "from (  " +
            "    select * from dwd_douyin_aweme_info  " +
            "        where publish_time &gt;= #{dto.start} and publish_time &lt;= #{dto.end}  " +
            ") t1 left join (  " +
            "        select aweme_id,collect_set(activity_id) as activity_id_list  " +
            "        from dwd_fhl_activity_douyin_aweme_info   " +
            "        where   " +
            "            publish_time &gt;= #{dto.start}   " +
            "            and publish_time &lt;= #{dto.end}  " +
            "            and " +
            "            <choose>" +
            "                 <when test=\"dto.activityIds != null\">" +
            "                 activity_id in " +
            "            <foreach collection='dto.activityIds' item='item' open='(' separator=',' close=')'>" +
            "               #{item}  " +
            "            </foreach>  " +
            "            </when> " +
            "            <otherwise> " +
            "            activity_id != '' " +
            "            </otherwise>  " +
            "        </choose>  " +
            "            and is_deleted = 0  " +
            "        group by aweme_id   " +
            "     ) t2 on t1.aweme_id = t2.aweme_id   " +
            "     left join dwd_douyin_author_info t3 on t1.author_id = t3.author_id   " +
            "where contains(split(t3.principal_ids,','),'869752931296989184')</script>")
    IPage<HongqiActivityAwemeVO> douyinActivityAwemes(IPage<HongqiActivityAwemeVO> page, @Param("dto") FawActivityDTO dto);

    @Select("<script>select  " +
            "    t1.aweme_id,  " +
            "    t1.aweme_title ,  " +
            "    'kuaishou' as platform,  " +
            "    t3.dealer_area_names area_name,  " +
            "    t3.dealer_store_code dealer_code,  " +
            "    t3.dealer_name ,  " +
            "    t3.nickname ,  " +
            "    t1.publish_time ,  " +
            "    t1.play_volume ,  " +
            "    nvl(t1.digg_count,0) + nvl(t1.comment_count,0) + nvl(t1.share_count,0) as polling_count,  " +
            "    t1.digg_count ,  " +
            "    t1.comment_count ,  " +
            "    t1.share_count ,  " +
            "    t1.share_url ,  " +
            "    t1.data_update_time ,  " +
            "    t2.activity_id_list  " +
            "from (  " +
            "    select * from dwd_kuaishou_aweme_info  " +
            "        where publish_time &gt;= #{dto.start} and publish_time &lt;= #{dto.end}  " +
            ") t1 left join (  " +
            "        select aweme_id,collect_set(activity_id) as activity_id_list  " +
            "        from dwd_fhl_activity_kuaishou_aweme_info   " +
            "        where   " +
            "            publish_time &gt;= #{dto.start}   " +
            "            and publish_time &lt;= #{dto.end}  " +
            "            and " +
            "            <choose>" +
            "                 <when test=\"dto.activityIds != null\">" +
            "                 activity_id in " +
            "            <foreach collection='dto.activityIds' item='item' open='(' separator=',' close=')'>" +
            "               #{item}  " +
            "            </foreach>  " +
            "            </when> " +
            "            <otherwise> " +
            "                   activity_id != '' " +
            "            </otherwise>  " +
            "        </choose>  " +
            "            and is_deleted = 0  " +
            "        group by aweme_id   " +
            "     ) t2 on t1.aweme_id = t2.aweme_id   " +
            "     left join dwd_kuaishou_author_info t3 on t1.author_id = t3.author_id   " +
            "where contains(split(t3.principal_ids,','),'869752931296989184')</script>")
    IPage<HongqiActivityAwemeVO> kuaishouActivityAwemes(IPage<HongqiActivityAwemeVO> page, @Param("dto") FawActivityDTO dto);

    @Select("<script>select  " +
            "    t1.room_id,  " +
            "    t1.title,  " +
            "    'douyin' as platform,  " +
            "    t3.dealer_area_names area_name,  " +
            "    t3.dealer_store_code dealer_code,  " +
            "    t3.dealer_name ,  " +
            "    t3.nickname ,  " +
            "    t1.publish_time ,  " +
            "    t1.statistics_total_watch_user_count ,  " +
            "    t1.statistics_live_time,  " +
            "    t1.statistics_total_polling_count as polling_cnt,  " +
            "    t1.statistics_total_like_count like_cnt,  " +
            "    t1.statistics_total_comment_count comment_cnt,  " +
            "    t1.statistics_total_gift_count gift_cnt,  " +
            "    t1.statistics_fans_add ,  " +
            "    t1.data_update_time ,  " +
            "    t2.activity_id_list  " +
            "from (  " +
            "    select * from dwd_douyin_live_info   " +
            "        where publish_time &gt;= #{dto.start} and publish_time &lt;= #{dto.end}  " +
            ") t1 left join (  " +
            "        select room_id,collect_set(activity_id) as activity_id_list  " +
            "        from dwd_fhl_activity_douyin_live_info   " +
            "        where publish_time &gt;= #{dto.start} and publish_time &lt;= #{dto.end}  " +
            "            and " +
            "            <choose>" +
            "                 <when test=\"dto.activityIds != null\">" +
            "                 activity_id in " +
            "            <foreach collection='dto.activityIds' item='item' open='(' separator=',' close=')'>" +
            "               #{item}  " +
            "            </foreach>  " +
            "            </when> " +
            "            <otherwise> " +
            "                   activity_id != '' " +
            "            </otherwise>  " +
            "        </choose>  " +
            "              and is_deleted = 0  " +
            "        group by room_id   " +
            "     ) t2 on t1.room_id = t2.room_id   " +
            "     left join dwd_douyin_author_info t3 on t1.author_id = t3.author_id   " +
            "where contains(split(t3.principal_ids,','),'869752931296989184')</script>")
    IPage<HongqiActivityLiveVO> douyinActivityLives(IPage<HongqiActivityLiveVO> page, @Param("dto") FawActivityDTO dto);

    @Select("<script>select  " +
            "    t1.room_id,  " +
            "    t1.title,  " +
            "    'douyin' as platform,  " +
            "    t3.dealer_area_names area_name,  " +
            "    t3.dealer_store_code dealer_code,  " +
            "    t3.dealer_name ,  " +
            "    t3.nickname ,  " +
            "    t1.publish_time ,  " +
            "    t1.statistics_total_watch_user_count ,  " +
            "    t1.statistics_live_time,  " +
            "    t1.statistics_total_polling_count as polling_cnt,  " +
            "    t1.statistics_total_like_count like_cnt,  " +
            "    t1.statistics_total_comment_count comment_cnt,  " +
            "    t1.statistics_total_gift_count gift_cnt,  " +
            "    t1.statistics_fans_add ,  " +
            "    t1.data_update_time ,  " +
            "    t2.activity_id_list  " +
            "from (  " +
            "    select * from dwd_kuaishou_live_info   " +
            "        where publish_time &gt;= #{dto.start} and publish_time &lt;= #{dto.end}  " +
            ") t1 left join (  " +
            "        select room_id,collect_set(activity_id) as activity_id_list  " +
            "        from dwd_fhl_activity_kuaishou_live_info   " +
            "        where publish_time &gt;= #{dto.start} and publish_time &lt;= #{dto.end}  " +
            "            and " +
            "            <choose>" +
            "                 <when test=\"dto.activityIds != null\">" +
            "                 activity_id in " +
            "            <foreach collection='dto.activityIds' item='item' open='(' separator=',' close=')'>" +
            "               #{item}  " +
            "            </foreach>  " +
            "            </when> " +
            "            <otherwise> " +
            "                   activity_id != '' " +
            "            </otherwise>  " +
            "        </choose>  " +
            "              and is_deleted = 0  " +
            "        group by room_id   " +
            "     ) t2 on t1.room_id = t2.room_id   " +
            "     left join dwd_kuaishou_author_info t3 on t1.author_id = t3.author_id   " +
            "where contains(split(t3.principal_ids,','),'869752931296989184')</script>")
    IPage<HongqiActivityLiveVO> kuaishouActivityLives(IPage<HongqiActivityLiveVO> page, @Param("dto") FawActivityDTO dto);
}
