package com.afanticar.afantiopenapi.controller;

import com.afanticar.afantiopenapi.model.BaseResponse;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * description
 *
 * @author LSZ 2021/01/07 16:34
 * @contact 648748030@qq.com
 */
public class BaseController {

    private static String CODE_SUCCESS = "200";

    private static String CODE_ERROR = "500";

    private static String MSG_ERROR = "发生未知异常，请联系管理员";

    public static String header = "clientId";

    public static <T> BaseResponse<T> success() {
        BaseResponse<T> result = new BaseResponse<>();
        result.setSuccess(true);
        result.setCode(CODE_SUCCESS);
        return result;
    }

    public static <T> BaseResponse<T> success(T data) {
        BaseResponse<T> successResult = success();
        successResult.setData(data);
        return successResult;
    }

    public static <T> BaseResponse<T> error() {
        return error(CODE_ERROR, MSG_ERROR);
    }

    public static <T> BaseResponse<T> error(String code, String msg) {
        BaseResponse<T> result = new BaseResponse<>();
        result.setSuccess(false);
        result.setMessage(msg);
        result.setCode(code);
        return result;
    }

    public static <T> BaseResponse<T> error(T data, String code, String msg) {
        BaseResponse<T> result = new BaseResponse<>();
        result.setSuccess(false);
        result.setMessage(msg);
        result.setCode(code);
        result.setData(data);
        return result;
    }

    protected HttpServletRequest getRequest() {
        return ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public Map<String, String> getParameterMap() {
        Map<String, String> params = new HashMap();
        Map<String, String[]> parameterMap = this.getRequest().getParameterMap();
        Iterator var3 = parameterMap.entrySet().iterator();

        while (var3.hasNext()) {
            Map.Entry<String, String[]> entry = (Map.Entry) var3.next();
            if (entry.getValue() != null && ((String[]) entry.getValue()).length != 0) {
                params.put(entry.getKey(), ((String[]) entry.getValue())[0]);
            }
        }
        return params;
    }
}
