package com.afanticar.afantiopenapi.service;

import com.afanticar.afantiopenapi.controller.BaseController;
import com.afanticar.afantiopenapi.model.BaseResponse;
import org.redisson.api.RRateLimiter;
import org.redisson.api.RateIntervalUnit;
import org.redisson.api.RateType;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.concurrent.TimeUnit;

/**
 * @author chin
 * @contact chenyan@afanticar.com
 * @since 2023/4/27/027
 */
@Service
public class BaseService {

    @Autowired
    RedissonClient redissonClient;

    int waiting = 50;

    public BaseResponse baseValidator(HttpServletRequest request, String clientId, String dataType, Integer limit, Integer limitPeriod) {
        if (!clientId.equals(request.getAttribute(BaseController.header))) {
            return BaseController.error("403", "认证用户无访问此数据的权限！");
        }
        String fawKey = String.format("%s:limit", dataType);
        RRateLimiter rateLimiter = redissonClient.getRateLimiter(fawKey);
        rateLimiter.trySetRate(RateType.OVERALL, limit,limitPeriod, RateIntervalUnit.SECONDS);
        if (!rateLimiter.tryAcquire(1, waiting, TimeUnit.MILLISECONDS)) {
            return BaseController.error("403", "您的请求太过频繁，请稍后再试！");
        }
        return null;
    }

    public BaseResponse baseLimit(HttpServletRequest request, String dataType, Integer limit, Integer limitPeriod) {
        String fawKey = String.format("%s:%s:limit", dataType, request.getHeader(BaseController.header));
        RRateLimiter rateLimiter = redissonClient.getRateLimiter(fawKey);
        rateLimiter.trySetRate(RateType.OVERALL, limit,limitPeriod, RateIntervalUnit.SECONDS);
        if (!rateLimiter.tryAcquire(1, waiting, TimeUnit.MILLISECONDS)) {
            return BaseController.error("403", "您的请求太过频繁，请稍后再试！");
        }
        return null;
    }

}
