package com.afanticar.afantiopenapi.model.entity;

import com.alibaba.fastjson.annotation.JSONType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @author hejincai
 * @since 2025/4/24 9:32
 **/
@Data
@TableName("open_api_client_principal_relation")
@JsonNaming(value = com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy.class)
@JSONType(naming = com.alibaba.fastjson.PropertyNamingStrategy.SnakeCase)
public class OpenApiClientPrincipalRelationEntity {

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("客户端id")
    private String clientId;

    @ApiModelProperty("主体id")
    private String principalId;

    @ApiModelProperty("删除状态")
    private Integer isDeleted;

    @ApiModelProperty("创建时间")
    private LocalDateTime ctime;

    @ApiModelProperty("修改时间")
    private LocalDateTime mtime;
}
