package com.afanticar.afantiopenapi.model.vo;

/**
 * @author chin
 * @contact chenyan@afanticar.com
 * @since 2023/4/26/026
 */

import com.alibaba.fastjson.annotation.JSONType;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 活动信息
 * @author Chin
 */
@Data
@JsonNaming(value = com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy.class)
@JSONType(naming = com.alibaba.fastjson.PropertyNamingStrategy.SnakeCase)
public class ActivityInfoVO {

    /** 活动ID */
    @ApiModelProperty(value = "活动ID", example = "200")
    private Integer activityId;
    /** 活动名称 */
    @ApiModelProperty(value = "活动名称", example = "3月活动")
    private String activityName;
    /** 活动规则 */
    @ApiModelProperty(value = "活动规则", example = "规则1：等等")
    private String participationRules;
    /** 奖励规则 */
    @ApiModelProperty(value = "奖励规则", example = "奖励规则")
    private String rewardRules;
    /** When the data was created */
    @ApiModelProperty(value = "活动创建时间", example = "2023-03-04 10:00:00")
    private Date creationTime;

}
