package com.afanticar.afantiopenapi.feign;

import com.afanticar.afantiopenapi.model.BaseResponse;
import com.afanticar.afantiopenapi.model.vo.TokenCheckVO;
import com.afanticar.afantiopenapi.model.vo.TokenVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Map;

/**
 * @author Chin
 */
@FeignClient(url = "${svc-prefix}" + "cas" + "${svc-suffix}", name = "cas", path = "/")
public interface AfantiCasFeign {

    /**
     * 获取token
     * @param request 参数
     * @return JSONObject结果
     */
    @PostMapping(value = "/oauth/token")
    BaseResponse<TokenVO> predict(@RequestParam Map<String, Object> request);


    /**
     * 分类标签
     * @param token 参数
     * @return JSONObject结果
     */
    @GetMapping(value = "/oauth/check_token")
    TokenCheckVO checkToken(@RequestParam("token") String token);
}
