package com.afanticar.afantiopenapi.config;

import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;

/**
 * @author chin
 * @contact chenyan@afanticar.com
 * @since 2022/2/14/014
 */
@Configuration
@Slf4j
public class RedissonConfig {

    @Resource
    private RedisProperties redisProperties;

    @Bean
    public RedissonClient getRedisson() {
        Config config = new Config();
        SingleServerConfig singleServerConfig = config.useSingleServer().setAddress("redis://" + this.redisProperties.getHost() + ":" + this.redisProperties.getPort())
                .setDatabase(this.redisProperties.getDatabase()).setConnectTimeout(10000).setTimeout(3000).setRetryInterval(1500).setRetryAttempts(3);
        if (StringUtil.isNotBlank(this.redisProperties.getPassword())) {
            singleServerConfig.setPassword(this.redisProperties.getPassword());
        }
        return Redisson.create(config);
    }

}
