package com.afanticar.afantiopenapi.config;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.afanticar.afantiopenapi.constant.Constant;
import com.afanticar.afantiopenapi.controller.BaseController;
import com.afanticar.afantiopenapi.feign.AfantiCasFeign;
import com.afanticar.afantiopenapi.model.BaseResponse;
import com.afanticar.afantiopenapi.model.vo.TokenCheckVO;
import com.afanticar.afantiopenapi.utils.JWTUtils;
import com.alibaba.fastjson.JSONObject;
import feign.FeignException;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.redisson.api.RBucket;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/**
 * @author chin
 * @contact chenyan@afanticar.com
 * @since 2023/4/26/026
 */
@Slf4j
@Setter
@Component
@ConfigurationProperties(prefix = "ignored")
public class TokenInterceptor implements HandlerInterceptor {

    @Autowired
    private AfantiCasFeign casFeign;

    @Autowired
    RedissonClient redissonClient;

    private Set<String> uris;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String requestUri = request.getRequestURI();
        log.info("请求uri" + requestUri);
        if (uris.contains(requestUri)) {
            return true;
        }
        String token = request.getHeader("authorization");
        if (StrUtil.isNotBlank(token)) {
            // 红旗旧接口不进行验证
            if(Constant.EXCLUDE_PATH.contains(requestUri)){
                return true;
            }
            try{
                String clientId = JWTUtils.getClientId(token);
                request.setAttribute("clientId", clientId);
                TokenCheckVO tokenCheckVO = this.getCasToken(clientId,token);
                if(tokenCheckVO == null || DateUtil.currentSeconds() > Long.valueOf(tokenCheckVO.getExp()).longValue()){
                    this.writeResponse(response,"token已过期");
                    return false;
                }
            }catch (FeignException e){
                if(e.status()==HttpServletResponse.SC_UNAUTHORIZED){
                    this.writeResponse(response,"Unauthorized");
                    return false;
                }
            }catch (Exception e){
                this.writeResponse(response,"认证失败,无效的token");
                return false;
            }
        } else {
            this.writeResponse(response,"认证失败,无效的token");
            return false;
        }
        return true;
    }

    private void writeResponse(HttpServletResponse response, String msg) throws Exception {
        response.setCharacterEncoding("UTF-8");
        response.setStatus(HttpServletResponse.SC_UNAUTHORIZED);
        response.setContentType("application/json");
        response.getWriter().append(JSONObject.toJSONString(BaseController.error("401", msg)));
    }

    private TokenCheckVO getCasToken(String clientId,String token) {
//        RBucket<TokenCheckVO> rBucket = redissonClient.getBucket(Constant.TOKEN_REDIS_KEY+clientId);
//        if(!rBucket.isExists()){
//            RLock lock = redissonClient.getLock(Constant.TOKEN_REDIS_LOCK+clientId);
//            lock.lock(5,TimeUnit.SECONDS);
//            try{
                TokenCheckVO checkVO = casFeign.checkToken(token);
//                rBucket.set(checkVO,24, TimeUnit.HOURS);
                return checkVO;
//            }catch (Exception e){
//                throw e;
//            }finally {
//                if(lock.isLocked()){
//                    lock.unlock();
//                }
//            }
//        }else{
//            return rBucket.get();
//        }
    }

}
