package com.afanticar.afantiopenapi.controller;

import cn.hutool.core.date.DateException;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.afanticar.afantiopenapi.constant.ExceptionEnum;
import com.afanticar.afantiopenapi.model.BaseResponse;
import com.afanticar.afantiopenapi.model.dto.FawActivityDTO;
import com.alibaba.fastjson.JSONObject;
import lombok.SneakyThrows;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * description
 *
 * @author LSZ 2021/01/07 16:34
 * @contact 648748030@qq.com
 */
public class BaseController extends HandlerInterceptorAdapter{

    private static String CODE_SUCCESS = "200";

    private static String CODE_ERROR = "500";

    private static String MSG_ERROR = "发生未知异常，请联系管理员";

    public static String header = "clientId";

    public static <T> BaseResponse<T> success() {
        BaseResponse<T> result = new BaseResponse<>();
        result.setSuccess(true);
        result.setCode(CODE_SUCCESS);
        return result;
    }

    public static <T> BaseResponse<T> success(T data) {
        BaseResponse<T> successResult = success();
        successResult.setData(data);
        return successResult;
    }

    public static <T> BaseResponse<T> error() {
        return error(CODE_ERROR, MSG_ERROR);
    }

    public static <T> BaseResponse<T> error(String code, String msg) {
        BaseResponse<T> result = new BaseResponse<>();
        result.setSuccess(false);
        result.setMessage(msg);
        result.setCode(code);
        return result;
    }

    public static <T> BaseResponse<T> error(T data, String code, String msg) {
        BaseResponse<T> result = new BaseResponse<>();
        result.setSuccess(false);
        result.setMessage(msg);
        result.setCode(code);
        result.setData(data);
        return result;
    }

    protected HttpServletRequest getRequest() {
        return ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public Map<String, String> getParameterMap() {
        Map<String, String> params = new HashMap();
        Map<String, String[]> parameterMap = this.getRequest().getParameterMap();
        Iterator var3 = parameterMap.entrySet().iterator();

        while (var3.hasNext()) {
            Map.Entry<String, String[]> entry = (Map.Entry) var3.next();
            if (entry.getValue() != null && ((String[]) entry.getValue()).length != 0) {
                params.put(entry.getKey(), ((String[]) entry.getValue())[0]);
            }
        }
        return params;
    }

    public static Date parseDate(String publishDateStr) {
        Date publishDate = null;
        try {
            publishDate = DateUtil.parse(publishDateStr, "yyyy-MM-dd");
        } catch (DateException ignore) {
        }
        return publishDate;
    }

    int dateNum = 31;

    public BaseResponse activityRequestDTO(FawActivityDTO dto) {
        Date publishDateEnd = StrUtil.isNotBlank(dto.getPublishDateEnd()) ? DateUtil.endOfDay(parseDate(dto.getPublishDateEnd())) : DateUtil.endOfDay(DateUtil.yesterday()),
                publishDateStart = StrUtil.isNotBlank(dto.getPublishDateStart()) ? parseDate(dto.getPublishDateStart()) : DateUtil.beginOfDay(DateUtil.offsetDay(publishDateEnd, -dateNum));
        if (publishDateEnd.after(DateUtil.date())) {
            return BaseController.error("10010", "时间右端点日期最大为昨日！");
        }
        if (DateUtil.between(publishDateEnd, publishDateStart, DateUnit.DAY) > dateNum) {
            return BaseController.error("10010", "时间跨度最大为31天！");
        }
//        if (CollectionUtils.isEmpty(dto.getActivityIds()) || dto.getActivityIds().size() > 5) {
//            return BaseController.error("10010", "活动ID不能为空，最大5个！");
//        }
        dto.setEnd(publishDateEnd);
        dto.setStart(publishDateStart);
        dto.setCurrent(dto.getCurrent() == null ? 1 : dto.getCurrent());
        dto.setSize(dto.getSize() == null ? 500 : dto.getSize());
        return null;
    }

    @SneakyThrows
    public static void setResponse(HttpServletResponse response, Integer errorCode, String msg) {
        response.setCharacterEncoding("UTF-8");
        response.setStatus(errorCode);
        response.setContentType("application/json");
        response.getWriter().append(JSONObject.toJSONString(BaseController.error(errorCode.toString(), msg)));
    }

}
