package com.afanticar.afantiopenapi.mapper;

import com.afanticar.afantiopenapi.model.entity.XiaoHongShuAuthorDay;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.time.LocalDate;

@Mapper
@DS("afanti-bi-app")
public interface XiaoHongShuAuthorDayMapper extends BaseMapper<XiaoHongShuAuthorDay> {
    @Select("select * " +
            "from dws_xiaohongshu_author_action_day \n" +
            "where author_id in (\n" +
            "   select author_id from ads_xiaohongshu_author_info \n" +
            "   where contains(principal_ids, #{principalId}) and is_deleted=0 \n" +
            ")\n" +
            "and statistics_day >= #{startDate} \n" +
            "and statistics_day <= #{endDate} \n" +
            "order by statistics_day,author_id"
    )
    Page<XiaoHongShuAuthorDay> queryAuthorDayByPrincipalId(
            Page page,
            @Param("principalId") String principalId,
            @Param("startDate") LocalDate startDate,
            @Param("endDate") LocalDate endDate
    );
}
