package com.afanticar.afantiopenapi.model.qto;

import com.afanticar.core.annotation.Id;
import com.afanticar.core.annotation.Index;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
@JsonNaming(value = com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy.class)
@ApiModel(value = "小红书笔记正文", description = "小红书笔记正文")
@Index(name = "dwd-xiaohongshu-note-info")
public class XiaoHongShuNoteDocQTO implements Serializable {
    private static final long serialVersionUID = -8753897697871869807L;

    @Id
    private String id;
    @ApiModelProperty("笔记ID")
    private String noteId;
    /**
     * 违规类型：22:画面提及违禁词
     */
    @ApiModelProperty("正文")
    private String description;

}
