package com.afanticar.afantiopenapi.service;

import com.afanticar.afantiopenapi.constant.PrincipalEnum;
import com.afanticar.afantiopenapi.mapper.*;
import com.afanticar.afantiopenapi.model.entity.*;
import com.afanticar.afantiopenapi.model.qto.XiaoHongShuNoteDocQTO;
import com.afanticar.afantiopenapi.model.vo.BasePageVO;
import com.afanticar.afantiopenapi.model.vo.BydXiaoHongShuAuthorDayVO;
import com.afanticar.afantiopenapi.model.vo.BydXiaoHongShuMemberDayVO;
import com.afanticar.afantiopenapi.model.vo.BydXiaoHongShuNoteDayVO;
import com.afanticar.core.entity.EsBaseQuery;
import com.afanticar.core.entity.InnerHits;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service
public class BydOpenService {
    @Resource
    MemberInfoMapper memberInfoMapper;
    @Resource
    XiaoHongShuMemberDayMapper memberDayMapper;
    @Resource
    XiaoHongShuAuthorInfoMapper authorInfoMapper;
    @Resource
    XiaoHongShuAuthorDayMapper authorDayMapper;
    @Resource
    XiaoHongShuNoteInfoMapper noteInfoMapper;
    @Resource
    XiaoHongShuNoteDayMapper noteDayMapper;

    @Resource
    XiaoHongShuNoteDocService noteDocService;


    public BasePageVO<BydXiaoHongShuMemberDayVO> fetchMemberDaySnap(PrincipalEnum principal,
                                                                    LocalDate startDate, LocalDate endDate, Integer currentPage, Integer pageSize){
        Page<BydXiaoHongShuMemberDayVO> page = new Page<>(currentPage, pageSize);
        Page<XiaoHongShuMemberDay> data = memberDayMapper.queryMemberDayByPrincipalId(page, principal.id, startDate, endDate);
        List<String> memberIds = data.getRecords().stream().map(XiaoHongShuMemberDay::getMatrixMemberId).distinct().collect(Collectors.toList());
        Map<String, MemberInfo> memberInfos = memberInfoMapper
                .queryMemberInfoListByMemberIds(memberIds.isEmpty()? Collections.singletonList("XXX") : memberIds)
                .stream().distinct()
                .collect(Collectors.toMap(MemberInfo::getMatrixMemberId, Function.identity()));

        List<BydXiaoHongShuMemberDayVO> voList = data.getRecords().stream().map(x->{
            BydXiaoHongShuMemberDayVO vo = new BydXiaoHongShuMemberDayVO();
            vo.setMemberId(x.getMatrixMemberId());
            MemberInfo info = memberInfos.get(x.getMatrixMemberId());
            if (Objects.nonNull(info)) {
                vo.setMemberName(info.getMatrixMemberName());
                vo.setMemberCode(info.getMatrixMemberCode());
                vo.setPrincipalName(info.getPrincipalName());
                vo.setAreaName(info.getAreaName());
                vo.setVillageName(info.getVillageName());
                vo.setCityName(info.getCityName());
                vo.setProvinceName(info.getProvinceName());
            }
            vo.setStatsDate(x.getStatisticsDay());
            vo.setFansCntTotal(x.getFansCountTotal());
            vo.setFansCntDi(x.getFansCountTotalDi());
            vo.setNoteCntDi(x.getNoteCountDi());
            vo.setNoteLikeCntDi(x.getNoteDiggCountDi());
            vo.setNoteCommentCntDi(x.getNoteCommentCountDi());
            vo.setNoteCollectCntDi(x.getNoteCollectCountDi());
            vo.setNoteShareCntDi(x.getNoteShareCountDi());
            return vo;
        }).collect(Collectors.toList());
        // List<String> memberIds = data.stream().map(XiaoHongShuMemberDay::getMatrixMemberId).collect(Collectors.toList());
        // List<MemberInfo> memberInfos = memberInfoMapper.queryMemberInfoListByMemberIds(memberIds);

        return BasePageVO.restPage((int) data.getCurrent(), (int) data.getSize(), (int) data.getTotal(), (int) data.getPages(), voList);

    }

    public BasePageVO<BydXiaoHongShuAuthorDayVO> fetchAuthorDaySnap(PrincipalEnum principal,
                                                                    LocalDate startDate, LocalDate endDate, Integer currentPage, Integer pageSize){
        Page<XiaoHongShuAuthorDay> page = new Page<>(currentPage, pageSize);
        Page<XiaoHongShuAuthorDay> data = authorDayMapper.queryAuthorDayByPrincipalId(page, principal.id, startDate, endDate);

        List<String> authorIds = data.getRecords().stream().map(XiaoHongShuAuthorDay::getAuthorId).distinct().collect(Collectors.toList());

        Map<String, XiaoHongShuAuthorInfo> authorInfos = authorInfoMapper
                .queryAuthorInfoListByAuthorIds(authorIds.isEmpty() ? Collections.singletonList("XXX") : authorIds)
                .stream().distinct()
                .collect(Collectors.toMap(XiaoHongShuAuthorInfo::getAuthorId, Function.identity()));

        List<String> memberIds = authorInfos.values().stream()
                .flatMap(o-> o.getMemberIds().stream())
                .collect(Collectors.toList());

        Map<String, MemberInfo> memberInfos = memberInfoMapper
                .queryMemberInfoListByMemberIds(memberIds.isEmpty() ? Collections.singletonList("XXX"): memberIds)
                .stream().distinct()
                .collect(Collectors.toMap(MemberInfo::getMatrixMemberId, Function.identity()));

        List<BydXiaoHongShuAuthorDayVO> voList = data.getRecords().stream().map(x->{
            BydXiaoHongShuAuthorDayVO vo = new BydXiaoHongShuAuthorDayVO();
            XiaoHongShuAuthorInfo authorInfo = authorInfos.get(x.getAuthorId());
            vo.setAuthorId(x.getAuthorId());
            vo.setNickname(authorInfo.getNickname());
            vo.setCode(authorInfo.getCode());
            vo.setAvatarUrl(authorInfo.getAvatar());
            vo.setBlueV(Optional.ofNullable(authorInfo.getVerificationType()).orElse(100).equals(2));
            vo.setIncludeTime(authorInfo.getIncludedTime());
            if (Optional.ofNullable(authorInfo.getMemberIds()).isPresent()) {
                vo.setMemberInfos(authorInfo.getMemberIds().stream().map(id->{
                    BydXiaoHongShuAuthorDayVO.MemberInfo infoVo = new BydXiaoHongShuAuthorDayVO.MemberInfo();
                    MemberInfo info = memberInfos.get(id);
                    if (Objects.nonNull(info)) {
                        infoVo.setMemberId(info.getMatrixMemberId());
                        infoVo.setMemberCode(info.getMatrixMemberCode());
                        infoVo.setMemberName(info.getMatrixMemberName());
                        infoVo.setAreaName(info.getAreaName());
                        infoVo.setVillageName(info.getVillageName());
                        infoVo.setPrincipalName(info.getPrincipalName());
                        infoVo.setCityName(info.getCityName());
                        infoVo.setProvinceName(info.getProvinceName());
                    }
                    return infoVo;
                }).collect(Collectors.toList()));
            } else {
                vo.setMemberInfos(new ArrayList<>());
            }
            vo.setStatsDate(x.getStatisticsDay());
            vo.setFansCntTotal(x.getFansCountTotal());
            vo.setFansCntDi(x.getFansCountTotalDi());
            vo.setNoteCntDi(x.getNoteCountDi());
            vo.setNoteLikeCntDi(x.getDiggCountDi());
            vo.setNoteCommentCntDi(x.getNoteCommentCountDi());
            vo.setNoteFavoriteCntDi(x.getCollectCountDi());
            vo.setNoteShareCntDi(x.getNoteShareCountDi());
            vo.setDataUpdateTime(x.getMtime());
            return vo;
        }).collect(Collectors.toList());


        return BasePageVO.restPage((int) data.getCurrent(), (int) data.getSize(), (int) data.getTotal(), (int) data.getPages(), voList);

    }
    public BasePageVO<BydXiaoHongShuNoteDayVO> fetchNoteDaySnap(PrincipalEnum principal,
                                                                LocalDate statsStart, LocalDate statsEnd,
                                                                LocalDate pubStart, LocalDate pubEnd,
                                                                Integer currentPage, Integer pageSize){

        Page<XiaoHongShuNoteDay> page = new Page<>(currentPage, pageSize);
        Page<XiaoHongShuNoteDay> data = noteDayMapper.queryNoteDayByPrincipalId(page, principal.id, statsStart, statsEnd, pubStart, pubEnd);

        List<String> noteIds = data.getRecords().stream().map(XiaoHongShuNoteDay::getNoteId).distinct().collect(Collectors.toList());

        Map<String, XiaoHongShuNoteInfo> noteInfos = noteInfoMapper
                .queryNoteInfoListByNoteIds(noteIds.isEmpty() ? Collections.singletonList("XXX") : noteIds)
                .stream().distinct()
                .collect(Collectors.toMap(XiaoHongShuNoteInfo::getNoteId, Function.identity()));

        EsBaseQuery esQuery = new EsBaseQuery();
        esQuery.terms("note_id", noteIds);
        List<InnerHits<XiaoHongShuNoteDocQTO>> searchResult = noteDocService.search(esQuery).getHits().getHits();
        Map<String, String> noteDocs = CollectionUtils.isNotEmpty(searchResult) ? searchResult.stream()
                .map(InnerHits::getSource)
                .collect(Collectors.toMap(XiaoHongShuNoteDocQTO::getNoteId, XiaoHongShuNoteDocQTO::getDescription))
                : new HashMap<>();

        List<BydXiaoHongShuNoteDayVO> voList = data.getRecords().stream().map(x->{
            BydXiaoHongShuNoteDayVO vo = new BydXiaoHongShuNoteDayVO();
            vo.setNoteId(x.getNoteId());
            vo.setStatsDate(x.getStatisticsDay());
            XiaoHongShuNoteInfo noteInfo = noteInfos.get(x.getNoteId());
            if (Optional.ofNullable(noteInfo).isPresent()) {
                vo.setNoteTitle(noteInfo.getNoteTitle());
                vo.setPublishTime(noteInfo.getPublishTime());
                vo.setNoteType(noteInfo.getNoteType());
                vo.setShareUrl(noteInfo.getShareUrl());
                vo.setCoverUrl(noteInfo.getCoverUrl());
                vo.setTopicNames(noteInfo.getTopicNames());
            }
            vo.setAuthorId(x.getAuthorId());
            vo.setLikeCnt(x.getDiggCount());
            vo.setCommentCnt(x.getCommentCount());
            vo.setCollectCnt(x.getCollectCount());
            vo.setShareCnt(x.getShareCount());
            vo.setDescription(noteDocs.get(x.getNoteId()));
            vo.setDataUpdateTime(x.getMtime());
            return vo;
        }).collect(Collectors.toList());


        return BasePageVO.restPage((int) data.getCurrent(), (int) data.getSize(), (int) data.getTotal(), (int) data.getPages(), voList);

    }



}
