package com.afanticar.afantiopenapi.mapper;

import com.afanticar.afantiopenapi.model.dto.OpenIdDTO;
import com.afanticar.afantiopenapi.model.entity.OpenApiClientPrincipalRelationEntity;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author hejincai
 * @since 2025/4/24 9:47
 */
@Mapper
@DS("master")
public interface OpenApiClientPrincipalRelationMapper extends BaseMapper<OpenApiClientPrincipalRelationEntity> {

    /**
     * 通过客户端id查询主体关系
     * @author hejincai
     * @since 2025/4/24 11:54
     * @return java.util.List<com.afanticar.afantiopenapi.model.entity.OpenApiClientPrincipalRelationEntity>
     * @param clientId 客户端id
     */
    List<OpenApiClientPrincipalRelationEntity> selectByClientId(@Param("clientId") String clientId);

    /**
     * 查询留资主播和粉丝open_id
     */
    List<OpenIdDTO> getOpenIdByStoreCodeAndPhone(@Param("storeCode") String storeCode, @Param("phone") String phone);
}
