package com.afanticar.afantiopenapi.constant;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;

/**
 * @author Wsr
 * @ClassName ExceptionEnum
 * @desc 异常枚举
 * @date 2023/01/06 18:59
 **/
@AllArgsConstructor
@NoArgsConstructor
public enum ExceptionEnum {

    /**
     *
     */
    USER_ERROR(400, "用户错误"),
    ERROR(500, "发生未知异常，请联系管理员"),
    SUCCESS(200, "成功"),
    PARAM_INVALID(90001, "请求参数不合法"),
    FLOW_LIMIT_ALL(10010, "访问过于频繁"),

    // ==================== token ====================
    /**
     * token 无效 401
     */
    TOKEN_INVALID(10002, "token 无效"),

    /**
     * token 过期
     */
    TOKEN_EXPIRED(10003, "token过期"),

    /**
     * token 不存在
     */
    TOKEN_NOT_EXIST(10004, "请求头未传递token"),

    // ==================== 限流 ====================
    /**
     * api限流
     */
    API_LIMIT_EXCEEDED(20001, "api限流"),

    /**
     * api-app限流
     */
    API_APP_LIMIT_EXCEEDED(20002, "特殊app限流"),

    /**
     * app限流
     */
    APP_LIMIT_EXCEEDED(20003, "app限流"),

    // ==================== 授权 ====================

    /**
     * app未授权
     */
    APP_UNAUTHORIZED(30001, "app未授权"),

    /**
     * app不存在
     */
    APP_NOT_EXIST(30002, "app不存在"),

    // ==================== 超时 ====================
    /**
     * 接口超时
     */
    API_TIMEOUT(40001, "接口超时"),

    /**
     * sql超时
     */
    SQL_TIMEOUT(40002, "sql超时"),

    // ==================== app ====================
    /**
     * app未注册
     */
    APP_UNREGISTERED(50001, "app未注册"),

    /**
     * app密钥错误 业务异常
     */
    APP_ERROR_SECRET(50002, "app密钥错误"),

    // ==================== data ====================
    /**
     * 字段重复
     */
    DUPLICATE_FIELD_ERROR(60001, "字段重复");

    @Getter
    private Integer code;

    @Getter
    private String message;

    public static ExceptionEnum findExceptionEnumByCode(Integer code) {
        for (ExceptionEnum exceptionEnum : values()) {
            if (exceptionEnum.code.equals(code)) {
                return exceptionEnum;
            }
        }
        return null;
    }
}
