package com.afanticar.afantiopenapi.controller;

import cn.hutool.core.date.DateException;
import cn.hutool.core.date.DateUtil;
import com.afanticar.afantiopenapi.model.BaseResponse;
import com.afanticar.afantiopenapi.model.entity.adb.DwdDouyinAuthorInfo;
import com.afanticar.afantiopenapi.model.entity.adb.DwdDouyinAwemeInfo;
import com.afanticar.afantiopenapi.model.entity.adb.DwdDouyinLiveInfo;
import com.afanticar.afantiopenapi.model.entity.adb.DwsFhlMkmsAuthorActionDay;
import com.afanticar.afantiopenapi.model.vo.BasePageVO;
import com.afanticar.afantiopenapi.service.AionOpenService;
import com.afanticar.afantiopenapi.service.BaseService;
import com.afanticar.afantiopenapi.utils.DateUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Max;
import java.util.Date;
import java.util.List;

/**
 * @author chin
 * @contact chenyan@afanticar.com
 * @since 2024/1/23/023
 */
@Api("埃安数据接口")
@RestController
@RequestMapping("/aion")
@Slf4j
@Validated
public class AionOpenController extends BaseController {

    @Autowired
    AionOpenService aionOpenService;

    @Autowired
    BaseService baseService;

    @Value("${aion.client}")
    String client;

    @Value("${aion.limit.period:60}")
    Integer limitPeriod;

    @Value("${aion.limit.threshold:3}")
    Integer limit;

    static String dataType = "aion";

    @ApiOperation(value = "主播数据信息", notes = "主播数据", produces = "application/json")
    @GetMapping("/douyin/author")
    public BaseResponse<List<DwdDouyinAuthorInfo>> getAuthorData(HttpServletRequest request) {
        BaseResponse check = baseService.baseValidator(request, client, dataType, limit, limitPeriod);
        if (check != null) {
            return check;
        }
        return success(aionOpenService.douyinAuthorInfo());
    }

    @ApiOperation(value = "视频数据信息", notes = "视频数据", produces = "application/json")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "publish_date_end", value = "结束时间，格式：2023-03-01 00:00:00", required = true, paramType = "path", dataType = "Date"),
            @ApiImplicitParam(name = "days", value = "时间跨度", paramType = "path", dataType = "Integer"),
            @ApiImplicitParam(name = "current_page", value = "页码", paramType = "path", dataType = "Integer"),
            @ApiImplicitParam(name = "page_size", value = "页数", paramType = "path", dataType = "Integer"),
    })
    @GetMapping("/douyin/aweme")
    public BaseResponse<BasePageVO<DwdDouyinAwemeInfo>> getAwemeData(HttpServletRequest request, @Max(value = 5000,message = "单页数据page_size过大") @RequestParam(name = "page_size", defaultValue = "5000", required = false) Integer pageSize,
                                                                     @RequestParam(name = "current_page", defaultValue = "1", required = false) Integer pageNum,
                                                                     @RequestParam(name = "publish_date_end", required = false) String publishDateEndStr,
                                                                     @RequestParam(name = "days", defaultValue = "30", required = false) Integer days) {
        BaseResponse check = baseService.baseValidator(request, client, dataType, limit, limitPeriod);
        if (check != null) {
            return check;
        }
        Date publishDateEnd;
        if (publishDateEndStr != null) {
            publishDateEnd = parseDate(publishDateEndStr);
        } else {
            publishDateEnd = DateUtils.getZeroDate(new Date());
        }
        String publishDateEndString = DateUtils.format(DateUtils.addDays(publishDateEnd, 1));
        String publishDateStartString = DateUtils.format(DateUtils.addDays(publishDateEnd, -days));
        return success(aionOpenService.douyinAwemeInfo(publishDateStartString, publishDateEndString, pageNum, pageSize));
    }

    @ApiOperation(value = "直播数据信息", notes = "直播数据", produces = "application/json")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "publish_date_end", value = "结束时间，格式：2023-03-01 00:00:00", required = true, paramType = "path", dataType = "Date"),
            @ApiImplicitParam(name = "days", value = "时间跨度", paramType = "path", dataType = "Integer"),
            @ApiImplicitParam(name = "current_page", value = "页码", paramType = "path", dataType = "Integer"),
            @ApiImplicitParam(name = "page_size", value = "页数", paramType = "path", dataType = "Integer"),
    })
    @GetMapping("/douyin/live")
    public BaseResponse<BasePageVO<DwdDouyinLiveInfo>> getLiveData(HttpServletRequest request, @Max(value = 5000,message = "单页数据page_size过大") @RequestParam(name = "page_size", defaultValue = "5000", required = false) Integer pageSize,
                                                                   @RequestParam(name = "current_page", defaultValue = "1", required = false) Integer pageNum,
                                                                   @RequestParam(name = "publish_date_end", required = false) String publishDateEndStr,
                                                                   @RequestParam(name = "days", defaultValue = "2", required = false) Integer days) {
        BaseResponse check = baseService.baseValidator(request, client, dataType, limit, limitPeriod);
        if (check != null) {
            return check;
        }
        Date publishDateEnd;
        if (publishDateEndStr != null) {
            publishDateEnd = parseDate(publishDateEndStr);
        } else {
            publishDateEnd = DateUtils.getZeroDate(new Date());
        }
        String publishDateEndString = DateUtils.format(DateUtils.addDays(publishDateEnd, 1));
        String publishDateStartString = DateUtils.format(DateUtils.addDays(publishDateEnd, -days));
        return success(aionOpenService.douyinLiveInfo(publishDateStartString, publishDateEndString, pageNum, pageSize));
    }

    @ApiOperation(value = "直播数据信息", notes = "直播数据", produces = "application/json")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "statistics_date", value = "统计时间，格式：2023-02-01", required = true, paramType = "path", dataType = "Date"),
            @ApiImplicitParam(name = "current_page", value = "页码", paramType = "path", dataType = "Integer"),
            @ApiImplicitParam(name = "page_size", value = "页数", paramType = "path", dataType = "Integer"),
    })
    @GetMapping("/douyin/author/private/chat")
    public BaseResponse<BasePageVO<DwsFhlMkmsAuthorActionDay>> getLiveData(HttpServletRequest request, @Max(value = 5000,message = "单页数据page_size过大") @RequestParam(name = "page_size", defaultValue = "5000", required = false) Integer pageSize,
                                                                           @RequestParam(name = "current_page", defaultValue = "1", required = false) Integer pageNum,
                                                                           @RequestParam(name = "statistics_date", required = false) String statisticsDateStr) {
        BaseResponse check = baseService.baseValidator(request, client, dataType, limit, limitPeriod);
        if (check != null) {
            return check;
        }
        Date publishDateEnd;
        if (statisticsDateStr != null) {
            publishDateEnd = parseDate(statisticsDateStr);
        } else {
            publishDateEnd = DateUtils.getZeroDate(new Date());
        }
        String publishDateEndString = DateUtils.format(DateUtils.addDays(publishDateEnd, 1));
        String publishDateStartString = DateUtils.format(publishDateEnd);
        return success(aionOpenService.douyinFhlMkmsAuthorInfo(publishDateStartString, publishDateEndString, pageNum, pageSize));
    }

    private static Date parseDate(String publishDateStr) {
        Date publishDate = null;
        try {
            publishDate = DateUtil.parse(publishDateStr, "yyyy-MM-dd");
        } catch (DateException ignore) {
        }
        return publishDate;
    }

}
