package com.afanticar.afantiopenapi.constant;

import java.util.Arrays;
import java.util.Optional;

public enum PrincipalEnum {
    BYD_WC("1270917477950984192", "比亚迪-王朝"),
    BYD_HY("1270917477950984192", "比亚迪-海洋"),
    BYD_TS("1270917477950984192", "比亚迪-腾势"),
    BYD_FCB("1270917477950984192", "比亚迪-方程豹"),
    SQDZ("869753088184930304", "SWM斯威汽车");

    // TODO: 修改ID
    public final String id;
    public final String shortName;

    PrincipalEnum(String id, String shortName) {
        this.id = id;
        this.shortName = shortName;
    }

    public static void main(String[] args) {
        System.out.println(PrincipalEnum.BYD_HY.name());
    }

    public static Optional<PrincipalEnum> getPrincipal(String principalCode) {
        return Arrays.stream(PrincipalEnum.values()).filter(x -> x.name().equals(principalCode)).findFirst();
    }

}
