package com.afanticar.afantiopenapi.mapper;

import com.afanticar.afantiopenapi.model.entity.XiaoHongShuMemberDay;
import com.afanticar.afantiopenapi.model.vo.BydXiaoHongShuMemberDayVO;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.time.LocalDate;

@Mapper
@DS("afanti-bi-app")
public interface XiaoHongShuMemberDayMapper extends BaseMapper<XiaoHongShuMemberDay> {


    @Select("select a.matrix_member_id,b.matrix_member_name as member_name,b.matrix_member_code as member_code,\n" +
            "       b.area_name,b.village_name,b.principal_name,b.province_name,b.city_name,\n" +
            "       a.statistics_day as stats_date,a.fans_count_total as fans_cnt_total,\n" +
            "       a.fans_count_total_di as fans_cnt_di,a.note_count_di as note_cnt_di,\n" +
            "       a.note_digg_count_di as note_like_cnt_di,a.note_collect_count_di as note_collect_count_di,\n" +
            "       a.note_share_count_di as note_share_cnt_di \n" +
            "from dws_xiaohongshu_member_action_day a  \n" +
            "inner join dim_matrix_member_info b on a.matrix_member_id =b.matrix_member_id\n" +
            "where 1=1 \n" +
            "and statistics_day >= #{startDate}\n" +
            "and statistics_day <= #{endDate}\n" +
            "and principal_id=#{principalId} \n" +
            "and end_time='2099-01-01' \n" +
            "and is_valid=1 \n" +
            "order by statistics_day,a.matrix_member_id"
    )
    Page<BydXiaoHongShuMemberDayVO> queryMemberDayByPrincipalId(
            Page page,
            @Param("principalId") String principalId,
            @Param("startDate") LocalDate startDate,
            @Param("endDate") LocalDate endDate
    );
}
