package com.afanticar.afantiopenapi.service;

import com.afanticar.afantiopenapi.constant.PrincipalEnum;
import com.afanticar.afantiopenapi.mapper.*;
import com.afanticar.afantiopenapi.model.entity.HongqiAwemeIncentiveMonthly;
import com.afanticar.afantiopenapi.model.entity.MemberInfo;
import com.afanticar.afantiopenapi.model.entity.XiaoHongShuMemberDay;
import com.afanticar.afantiopenapi.model.entity.XiaoHongShuNoteInfo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class BydOpenService {
    @Resource
    MemberInfoMapper memberInfoMapper;
    @Resource
    XiaoHongShuMemberDayMapper memberDayMapper;
    @Resource
    XiaoHongShuAuthorInfoMapper authorInfoMapper;
    @Resource
    XiaoHongShuAuthorDayMapper authorDayMapper;
    @Resource
    XiaoHongShuNoteInfo noteInfoMapper;
    @Resource
    XiaoHongShuNoteDayMapper noteDayMapper;


    public void fetchMemberDayData(PrincipalEnum principal,
                                   LocalDate startDate, LocalDate endDate, Integer pageNum, Integer pageSize){
        IPage<XiaoHongShuMemberDay> page = new Page<>(pageNum, pageSize);
        QueryWrapper<XiaoHongShuMemberDay> queryWrapper = new QueryWrapper<>();

        List<XiaoHongShuMemberDay> data = memberDayMapper.queryMemberDayByPrincipalId(principal.id, startDate, endDate);
        List<String> memberIds = data.stream().map(XiaoHongShuMemberDay::getMatrixMemberId).collect(Collectors.toList());
        List<MemberInfo> memberInfos = memberInfoMapper.queryMemberInfoListByMemberIds(memberIds);



    }


}
