package com.afanticar.afantiopenapi.mapper;

import com.afanticar.afantiopenapi.model.entity.XiaoHongShuMemberDay;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.time.LocalDate;
import java.util.List;
import java.util.Set;

@Mapper
@DS("tmp")
public interface XiaoHongShuMemberDayMapper extends BaseMapper<XiaoHongShuMemberDay> {


    @Select("select a.* \n" +
            "from dws_xiaohongshu_member_action_day a \n" +
            "inner join (select matrix_member_ids from ads_xiaohongshu_author_info where contains(principal_ids, #{principalId})) b \n" +
            "on contains(b.matrix_member_ids,a.matrix_member_id)\n" +
            "where 1=1\n" +
            "and statistics_day >= #{startDate}\n" +
            "and statistics_day <= #{endDate}")
    List<XiaoHongShuMemberDay> queryMemberDayByPrincipalId(@Param("principalId") String principalId,
                                                           @Param("startDate") LocalDate startDate,
                                                           @Param("endDate") LocalDate endDate);
}
