package com.afanticar.afantiopenapi.model.entity;

import com.alibaba.fastjson.annotation.JSONType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@TableName("ads_xiaohongshu_author_info")
@JsonNaming(value = com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy.class)
@JSONType(naming = com.alibaba.fastjson.PropertyNamingStrategy.SnakeCase)
public class XiaoHongShuAuthorInfo {
    /**
     * 主播ID
     */
    private String authorId;

    /**
     * 主播签名
     */
    private String signature;

    /**
     * 主播昵称
     */
    private String nickname;

    /**
     * 主播头像
     */
    private String avatar;

    /**
     * 主播小红书号
     */
    private String code;

    /**
     * 主播主页背景图链接
     */
    private String coverUrl;

    /**
     * 主播性别
     */
    private Byte gender;

    /**
     * 主播生日
     */
    private String birthday;

    /**
     * 主播所在城市code
     */
    private String authorCityCode;

    /**
     * 主播所在城市名称
     */
    private String authorCityName;

    /**
     * 主播所在省code
     */
    private String authorProvinceCode;

    /**
     * 主播所在省名称
     */
    private String authorProvinceName;

    /**
     * 主播总粉丝数
     */
    private Integer fansCountTotal;

    /**
     * 小红书返回的主播状态，0正常、1注销、2封禁
     */
    private Byte platformAuthorStatus;

    /**
     * 经销商id
     */
    private String dealerId;

    /**
     * 经销商名称
     */
    private String dealerName;

    /**
     * 经销商城市code
     */
    private String dealerCityCode;

    /**
     * 经销商城市名称
     */
    private String dealerCityName;

    /**
     * 经销商地区code
     */
    private String dealerCountyCode;

    /**
     * 经销商地区名称
     */
    private String dealerCountyName;

    /**
     * 经销商省份code
     */
    private String dealerProvinceCode;

    /**
     * 经销商省份名称
     */
    private String dealerProvinceName;

    /**
     * 经销商公司名
     */
    private String dealerCompanyName;

    /**
     * 主机厂ids
     */
    private List<String> manufactorIds;

    /**
     * 主机厂名称
     */
    private List<String> manufactorNames;

    /**
     * 品牌ids
     */
    private List<String> brandIds;

    /**
     * 品牌名称
     */
    private List<String> brandNames;

    /**
     * 主体ids
     */
    private List<String> principalIds;

    /**
     * 主体名称
     */
    private List<String> principalNames;

    /**
     * 运营主体：1:品牌,2:主机厂,3:主体大区,4:经销商,5:KOIP,6:二手车商
     */
    private String operateType;

    /**
     * 经销商大区id,多列值
     */
    private List<String> dealerAreaIds;

    /**
     * 经销商大区名称,多列值
     */
    private List<String> dealerAreaNames;

    /**
     * 经销商原始门店编码
     */
    private String originStoreCode;

    /**
     * 排序权重
     */
    private String sortWeight;

    /**
     * 主播状态是否删除, 0正常;1删除
     */
    private Byte isDeleted;

    /**
     * 数据同步更新的时间点
     */
    private Date dataUpdateTime;

    /**
     * 账号收录时间
     */
    private Date includedTime;

    /**
     * 创建时间
     */
    private Date ctime;

    /**
     * 更新时间
     */
    private Date mtime;

    /**
     * 成员ids
     */
    private List<String> matrixMemberIds;

    /**
     * 获赞+收藏
     */
    private Integer favedCount;

    /**
     * 关注数
     */
    private Integer followingCount;

    /**
     * 点赞数
     */
    private Integer likeCountTotal;

    /**
     * 收藏数
     */
    private Integer collectCountTotal;

    /**
     * 主播总作品数
     */
    private Integer noteCountTotal;

    /**
     * 认证类型: 0-未认证, 1-个人认证，2-企业认证(蓝v)，3-机构认证
     */
    private String verificationType;

    /**
     * 是否代运营账号,1:是,0否
     */
    private Integer isAgentAuthor;
}
