package com.afanticar.afantiopenapi.model.entity;

import com.alibaba.fastjson.annotation.JSONType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@TableName("ads_xiaohongshu_note_info")
@JsonNaming(value = com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy.class)
@JSONType(naming = com.alibaba.fastjson.PropertyNamingStrategy.SnakeCase)
public class XiaoHongShuNoteInfo {
    /**
     * 小红书号
     */
    private String authorId;

    /**
     * 笔记id
     */
    private String noteId;

    /**
     * 笔记封面
     */
    private String coverUrl;

    /**
     * 笔记标题
     */
    private String noteTitle;

    /**
     * 笔记类型（normal：图文，video：视频）
     */
    private String noteType;

    /**
     * 笔记链接
     */
    private String shareUrl;

    /**
     * 阅读量
     */
    private Integer readCount;

    /**
     * 直接涨粉数
     */
    private Integer fansTotalAdd;

    /**
     * 点赞量
     */
    private Integer diggCount;

    /**
     * 收藏数
     */
    private Integer collectCount;

    /**
     * 评论数
     */
    private Integer commentCount;

    /**
     * 分享数
     */
    private Integer shareCount;

    /**
     * 入库时间
     */
    private Date ctime;

    /**
     * 修改时间
     */
    private Date mtime;

    /**
     * 成员ids
     */
    private List<String> matrixMemberIds;

    /**
     * 笔记发布时间
     */
    private Date publishTime;

    /**
     * 数据同步更新的时间点
     */
    private Date dataUpdateTime;

    /**
     * 笔记状态： 1-可见，0-不可见
     */
    private Integer noteStatus;

    /**
     * 话题ID列表
     */
    private List<String> topicIds;

    /**
     * 话题名
     */
    private String noteTopic;

    /**
     * 预估的模拟阅读量：（点赞+评论+收藏+转发）*20
     */
    private Integer simulateReadCount;

    /**
     * 笔记图片数
     */
    private Integer noteImageCount;

    /**
     * 笔记正文字数
     */
    private Integer noteDescriptionWordCount;

    /**
     * 1级标签 id
     */
    private String tagLevelOneId;

    /**
     * 1级标签 名
     */
    private String tagLevelOneName;

    /**
     * 2级标签 id
     */
    private String tagLevelTwoId;

    /**
     * 2级标签 名
     */
    private String tagLevelTwoName;

    /**
     * 3级标签 id
     */
    private String tagLevelThreeId;

    /**
     * 3级标签 名
     */
    private String tagLevelThreeName;

    /**
     * 发布渠道，FENGHUOLUN=风火轮，SHARE_LINK=分享链接，BAIFUZHANG=百夫长
     */
    private String publishChannel;

    /**
     * 产品id
     */
    private String goodsId;

    /**
     * 产品名称
     */
    private String goodsName;
}
